/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.MutationFetcher;
import java.util.LinkedHashMap;
import java.util.Map;

public class InsertMutationFetcher
extends MutationFetcher {
    public InsertMutationFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(table, nameMapping, persistence, authenticationService);
    }

    @Override
    protected String buildStatement(DataFetchingEnvironment environment, DataStore dataStore) {
        RegularInsert insert = QueryBuilder.insertInto((String)this.table.keyspace(), (String)this.table.name()).values(this.buildInsertValues(environment));
        if (environment.containsArgument("ifNotExists") && environment.getArgument("ifNotExists") != null && ((Boolean)environment.getArgument("ifNotExists")).booleanValue()) {
            insert = insert.ifNotExists();
        }
        if (environment.containsArgument("options") && environment.getArgument("options") != null) {
            Map options = (Map)environment.getArgument("options");
            if (options.containsKey("ttl") && options.get("ttl") != null) {
                insert = insert.usingTtl(((Integer)options.get("ttl")).intValue());
            }
            if (!options.containsKey("consistency") || options.get("consistency") != null) {
                // empty if block
            }
            if (!options.containsKey("serialConsistency") || options.get("serialConsistency") != null) {
                // empty if block
            }
        }
        return insert.asCql();
    }

    private Map<String, Term> buildInsertValues(DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        Preconditions.checkNotNull((Object)value, (Object)"Insert statement must contain at least one field");
        LinkedHashMap<String, Term> insertMap = new LinkedHashMap<String, Term>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.getColumn(this.table, (String)entry.getKey());
            insertMap.put(column.name(), (Term)this.toDbLiteral(column, entry.getValue()));
        }
        return insertMap;
    }
}

