/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.querybuilder.Literal;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class DmlFetcher
extends CassandraFetcher<Map<String, Object>> {
    protected final Table table;
    protected final NameMapping nameMapping;

    protected DmlFetcher(Table table, NameMapping nameMapping, Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
        this.table = table;
        this.nameMapping = nameMapping;
    }

    protected List<Condition> buildIfConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Condition> clause = new ArrayList<Condition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                if (condition.getKey().equals("in")) {
                    clause.add((Condition)Condition.column((String)column.name()).in(this.buildListLiterals(column, condition.getValue())));
                    continue;
                }
                Literal dbValue = this.toDbLiteral(column, condition.getValue());
                switch (condition.getKey()) {
                    case "eq": {
                        clause.add((Condition)Condition.column((String)column.name()).isEqualTo((Term)dbValue));
                        break;
                    }
                    case "notEq": {
                        clause.add((Condition)Condition.column((String)column.name()).isNotEqualTo((Term)dbValue));
                        break;
                    }
                    case "gt": {
                        clause.add((Condition)Condition.column((String)column.name()).isGreaterThan((Term)dbValue));
                        break;
                    }
                    case "gte": {
                        clause.add((Condition)Condition.column((String)column.name()).isGreaterThanOrEqualTo((Term)dbValue));
                        break;
                    }
                    case "lt": {
                        clause.add((Condition)Condition.column((String)column.name()).isLessThan((Term)dbValue));
                        break;
                    }
                    case "lte": {
                        clause.add((Condition)Condition.column((String)column.name()).isLessThanOrEqualTo((Term)dbValue));
                        break;
                    }
                }
            }
        }
        return clause;
    }

    private List<Term> buildListLiterals(Column column, Object o) {
        if (o instanceof Collection) {
            Collection values = (Collection)o;
            return values.stream().map(item -> this.toDbLiteral(column, item)).collect(Collectors.toList());
        }
        return Collections.singletonList(this.toDbLiteral(column, o));
    }

    protected List<Relation> buildFilterConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            Column column = this.getColumn(table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                if (condition.getKey().equals("in")) {
                    relations.add((Relation)Relation.column((String)column.name()).in(this.buildListLiterals(column, condition.getValue())));
                }
                Literal dbValue = this.toDbLiteral(column, condition.getValue());
                switch (condition.getKey()) {
                    case "eq": {
                        relations.add((Relation)Relation.column((String)column.name()).isEqualTo((Term)dbValue));
                        break;
                    }
                    case "notEq": {
                        relations.add((Relation)Relation.column((String)column.name()).isNotEqualTo((Term)dbValue));
                        break;
                    }
                    case "gt": {
                        relations.add((Relation)Relation.column((String)column.name()).isGreaterThan((Term)dbValue));
                        break;
                    }
                    case "gte": {
                        relations.add((Relation)Relation.column((String)column.name()).isGreaterThanOrEqualTo((Term)dbValue));
                        break;
                    }
                    case "lt": {
                        relations.add((Relation)Relation.column((String)column.name()).isLessThan((Term)dbValue));
                        break;
                    }
                    case "lte": {
                        relations.add((Relation)Relation.column((String)column.name()).isLessThanOrEqualTo((Term)dbValue));
                        break;
                    }
                }
            }
        }
        return relations;
    }

    protected List<Relation> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildFilterConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            relations.add((Relation)Relation.column((String)this.getDBColumnName(table, (String)entry.getKey())).isEqualTo((Term)QueryBuilder.literal(entry.getValue())));
        }
        return relations;
    }

    protected String getDBColumnName(Table table, String fieldName) {
        Column column = this.getColumn(table, fieldName);
        if (column == null) {
            return null;
        }
        return column.name();
    }

    protected Column getColumn(Table table, String fieldName) {
        return (Column)this.nameMapping.getColumnName(table).inverse().get((Object)fieldName);
    }

    protected Literal toDbLiteral(Column column, Object value) {
        return QueryBuilder.literal((Object)DataTypeMapping.toDbValue(column.type(), value));
    }
}

