/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class DataTypeMapping {
    DataTypeMapping() {
    }

    static Object toDbValue(Column.ColumnType type, Object value) {
        if (value == null || !type.isCollection()) {
            return value;
        }
        if (type.rawType() == Column.Type.List) {
            if (!((Column.ColumnType)type.parameters().get(0)).isCollection()) {
                return value;
            }
            return DataTypeMapping.itemsToDbValue((Column.ColumnType)type.parameters().get(0), (Collection)value);
        }
        if (type.rawType() == Column.Type.Set) {
            return new HashSet(DataTypeMapping.itemsToDbValue((Column.ColumnType)type.parameters().get(0), (Collection)value));
        }
        if (type.rawType() == Column.Type.Map) {
            Collection sourceMaps = (Collection)value;
            HashMap<Object, Object> targetMap = new HashMap<Object, Object>(sourceMaps.size());
            Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
            Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
            for (Map kv : sourceMaps) {
                targetMap.put(DataTypeMapping.toDbValue(keyType, kv.get("key")), DataTypeMapping.toDbValue(valueType, kv.get("value")));
            }
            return targetMap;
        }
        return value;
    }

    private static List<?> itemsToDbValue(Column.ColumnType itemType, Collection<?> collection) {
        return collection.stream().map(item -> DataTypeMapping.toDbValue(itemType, item)).collect(Collectors.toList());
    }

    static Map<String, Object> toGraphQLValue(NameMapping nameMapping, Table table, Row row) {
        List columns = row.columns();
        HashMap<String, Object> map = new HashMap<String, Object>(columns.size());
        for (Column column : columns) {
            if (row.isNull(column.name())) continue;
            map.put((String)nameMapping.getColumnName(table).get((Object)column), DataTypeMapping.toGraphQLValue(column, row));
        }
        return map;
    }

    private static Object toGraphQLValue(Column column, Row row) {
        Object dbValue = row.getObject(column.name());
        return DataTypeMapping.toGraphQLValue(column.type(), dbValue);
    }

    private static Object toGraphQLValue(Column.ColumnType type, Object dbValue) {
        if (!type.isCollection() || dbValue == null) {
            return dbValue;
        }
        if (type.rawType() == Column.Type.Map) {
            Map dbMap = (Map)dbValue;
            Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
            Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
            return dbMap.entrySet().stream().map(e -> {
                HashMap<String, Object> m = new HashMap<String, Object>(2);
                m.put("key", DataTypeMapping.toGraphQLValue(keyType, e.getKey()));
                m.put("value", DataTypeMapping.toGraphQLValue(valueType, e.getValue()));
                return m;
            }).collect(Collectors.toList());
        }
        Column.ColumnType itemType = (Column.ColumnType)type.parameters().get(0);
        if (itemType.isCollection()) {
            Collection dbCollection = (Collection)dbValue;
            return dbCollection.stream().map(item -> DataTypeMapping.toGraphQLValue(itemType, item)).collect(Collectors.toList());
        }
        return dbValue;
    }
}

