/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.schema.fetchers.ddl.DdlQueryFetcher;
import java.util.List;
import java.util.Map;

public class CreateTableFetcher
extends DdlQueryFetcher {
    public CreateTableFetcher(Persistence persistence, AuthenticationService authenticationService) {
        super(persistence, authenticationService);
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        List values;
        CreateTableStart start = SchemaBuilder.createTable((String)((String)dataFetchingEnvironment.getArgument("keyspaceName")), (String)((String)dataFetchingEnvironment.getArgument("tableName")));
        Boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgument("ifNotExists");
        if (ifNotExists != null && ifNotExists.booleanValue()) {
            start = start.ifNotExists();
        }
        CreateTable table = null;
        List partitionKeys = (List)dataFetchingEnvironment.getArgument("partitionKeys");
        if (partitionKeys.isEmpty()) {
            throw new IllegalArgumentException("partitionKeys must contain at least one element");
        }
        for (Object key : partitionKeys) {
            if (table != null) {
                table = table.withPartitionKey((String)key.get("name"), this.decodeType(key.get("type")));
                continue;
            }
            table = start.withPartitionKey((String)key.get("name"), this.decodeType(key.get("type")));
        }
        List clusteringKeys = (List)dataFetchingEnvironment.getArgument("clusteringKeys");
        if (clusteringKeys != null) {
            for (Object key : clusteringKeys) {
                table = table.withClusteringColumn((String)key.get("name"), this.decodeType(key.get("type")));
            }
        }
        if ((values = (List)dataFetchingEnvironment.getArgument("values")) != null) {
            for (Object key : values) {
                table = table.withColumn((String)key.get("name"), this.decodeType(key.get("type")));
            }
        }
        CreateTableWithOptions options = null;
        if (clusteringKeys != null) {
            for (Map key : clusteringKeys) {
                if (options == null) {
                    options = (CreateTableWithOptions)table.withClusteringOrder((String)key.get("name"), this.decodeClusteringOrder((String)key.get("order")));
                    continue;
                }
                options = (CreateTableWithOptions)options.withClusteringOrder((String)key.get("name"), this.decodeClusteringOrder((String)key.get("order")));
            }
        }
        String query = options != null ? options.build().getQuery() : table.build().getQuery();
        return query;
    }

    private ClusteringOrder decodeClusteringOrder(String order) {
        if (order == null) {
            return ClusteringOrder.ASC;
        }
        return ClusteringOrder.valueOf((String)order);
    }
}

