/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;

public abstract class CassandraFetcher<ResultT>
implements DataFetcher<ResultT> {
    protected final Persistence persistence;
    protected final AuthenticationService authenticationService;

    public CassandraFetcher(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    public final ResultT get(DataFetchingEnvironment environment) throws Exception {
        HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        StoredCredentials storedCredentials = this.authenticationService.validateToken(token);
        DataStore dataStore = DataStore.create((Persistence)this.persistence, (String)storedCredentials.getRoleName());
        return this.get(environment, dataStore);
    }

    protected abstract ResultT get(DataFetchingEnvironment var1, DataStore var2) throws Exception;
}

