/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import io.stargate.auth.AuthenticationService;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.graphql.WebImpl;
import net.jcip.annotations.GuardedBy;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlActivator.class);
    private static final String AUTH_IDENTIFIER = System.getProperty("stargate.auth_id", "AuthTableBasedService");
    private static final String PERSISTENCE_IDENTIFIER = System.getProperty("stargate.persistence_id", "CassandraPersistence");
    private static final String DEPENDENCIES_FILTER = String.format("(|(AuthIdentifier=%s)(Identifier=%s)(objectClass=%s))", AUTH_IDENTIFIER, PERSISTENCE_IDENTIFIER, Metrics.class.getName());
    @GuardedBy(value="this")
    private Tracker tracker;
    @GuardedBy(value="this")
    private WebImpl web;

    public synchronized void start(BundleContext context) throws InvalidSyntaxException {
        this.tracker = new Tracker(context, context.createFilter(DEPENDENCIES_FILTER));
        this.tracker.open();
    }

    public synchronized void stop(BundleContext context) {
        this.maybeStopService();
        this.tracker.close();
    }

    private synchronized void maybeStartService(Persistence persistence, Metrics metrics, AuthenticationService authentication) {
        if (this.web == null) {
            try {
                this.web = new WebImpl(persistence, metrics, authentication);
                LOG.info("Starting GraphQL");
                this.web.start();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }

    private synchronized void maybeStopService() {
        if (this.web != null) {
            try {
                LOG.info("Stopping GraphQL");
                this.web.stop();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }

    private class Tracker
    extends ServiceTracker<Object, Object> {
        private Persistence persistence;
        private Metrics metrics;
        private AuthenticationService authentication;

        public Tracker(BundleContext context, Filter filter) {
            super(context, filter, null);
        }

        public Object addingService(ServiceReference<Object> ref) {
            Object service = super.addingService(ref);
            if (this.persistence == null && service instanceof Persistence) {
                LOG.debug("Using backend persistence: {}", (Object)ref.getBundle());
                this.persistence = (Persistence)service;
            } else if (this.metrics == null && service instanceof Metrics) {
                LOG.debug("Using metrics: {}", (Object)ref.getBundle());
                this.metrics = (Metrics)service;
            } else if (this.authentication == null && service instanceof AuthenticationService) {
                LOG.debug("Using authentication service: {}", (Object)ref.getBundle());
                this.authentication = (AuthenticationService)service;
            }
            if (this.persistence != null && this.metrics != null && this.authentication != null) {
                GraphqlActivator.this.maybeStartService(this.persistence, this.metrics, this.authentication);
            }
            return service;
        }
    }
}

