/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.GraphQLException;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.context.ContextSetting;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.AbstractGraphQLInvocationInputParser;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class GraphQLPostInvocationInputParser
extends AbstractGraphQLInvocationInputParser {
    private static final String APPLICATION_GRAPHQL = "application/graphql";

    GraphQLPostInvocationInputParser(GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper, ContextSetting contextSetting) {
        super(invocationInputFactory, graphQLObjectMapper, contextSetting);
    }

    @Override
    public GraphQLInvocationInput getGraphQLInvocationInput(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (APPLICATION_GRAPHQL.equals(request.getContentType())) {
            String query = request.getReader().lines().collect(Collectors.joining());
            GraphQLRequest graphqlRequest = GraphQLRequest.createQueryOnlyRequest((String)query);
            return this.invocationInputFactory.create(graphqlRequest, request, response);
        }
        String body = request.getReader().lines().collect(Collectors.joining());
        if (this.isSingleQuery(body)) {
            GraphQLRequest graphqlRequest = this.graphQLObjectMapper.readGraphQLRequest(body);
            return this.invocationInputFactory.create(graphqlRequest, request, response);
        }
        if (this.isBatchedQuery(body)) {
            List requests = this.graphQLObjectMapper.readBatchedGraphQLRequest(body);
            return this.invocationInputFactory.create(this.contextSetting, requests, request, response);
        }
        throw new GraphQLException("No valid query found in request");
    }
}

