/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.fetchers;

import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.fetchers.AlterTableAddFetcher;
import io.stargate.graphql.fetchers.AlterTableDropFetcher;
import io.stargate.graphql.fetchers.CreateKeyspaceFetcher;
import io.stargate.graphql.fetchers.CreateTableDataFetcher;
import io.stargate.graphql.fetchers.DropTableFetcher;
import io.stargate.graphql.fetchers.SchemaFetcher;

public class SchemaDataFetcherFactory {
    private final Persistence persistence;
    private AuthenticationService authenticationService;

    public SchemaDataFetcherFactory(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    public SchemaFetcher createSchemaFetcher(String fetcher) {
        switch (fetcher) {
            case "io.stargate.graphql.fetchers.CreateKeyspaceFetcher": {
                return new CreateKeyspaceFetcher(this.persistence, this.authenticationService);
            }
            case "io.stargate.graphql.fetchers.AlterTableAddFetcher": {
                return new AlterTableAddFetcher(this.persistence, this.authenticationService);
            }
            case "io.stargate.graphql.fetchers.AlterTableDropFetcher": {
                return new AlterTableDropFetcher(this.persistence, this.authenticationService);
            }
            case "io.stargate.graphql.fetchers.CreateTableDataFetcher": {
                return new CreateTableDataFetcher(this.persistence, this.authenticationService);
            }
            case "io.stargate.graphql.fetchers.DropTableFetcher": {
                return new DropTableFetcher(this.persistence, this.authenticationService);
            }
        }
        throw new IllegalStateException("Unexpected value: " + fetcher);
    }
}

