/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.fetchers;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.ClientState;
import io.stargate.db.Persistence;
import io.stargate.db.QueryState;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.fetchers.SchemaFetcher;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CreateTableDataFetcher
implements SchemaFetcher,
DataFetcher {
    private final Persistence persistence;
    private AuthenticationService authenticationService;

    public CreateTableDataFetcher(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        StoredCredentials storedCredentials = this.authenticationService.validateToken(token);
        ClientState clientState = this.persistence.newClientState(storedCredentials.getRoleName());
        QueryState queryState = this.persistence.newQueryState(clientState);
        DataStore dataStore = this.persistence.newDataStore(queryState, null);
        CompletableFuture resultSetSingle = dataStore.query(this.getQuery(environment), new Object[0]);
        resultSetSingle.get();
        return true;
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        List values;
        CreateTableStart start = SchemaBuilder.createTable((String)((String)dataFetchingEnvironment.getArgument("keyspaceName")), (String)((String)dataFetchingEnvironment.getArgument("tableName")));
        Boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgument("ifNotExists");
        if (ifNotExists != null && ifNotExists.booleanValue()) {
            start = start.ifNotExists();
        }
        CreateTable table = null;
        List partitionKeys = (List)dataFetchingEnvironment.getArgument("partitionKeys");
        if (partitionKeys.isEmpty()) {
            throw new IllegalArgumentException("partitionKeys must contain at least one element");
        }
        for (Object key : partitionKeys) {
            if (table != null) {
                table = table.withPartitionKey((String)key.get("name"), this.decodeType(key.get("type")));
                continue;
            }
            table = start.withPartitionKey((String)key.get("name"), this.decodeType(key.get("type")));
        }
        List clusteringKeys = (List)dataFetchingEnvironment.getArgument("clusteringKeys");
        if (clusteringKeys != null) {
            for (Object key : clusteringKeys) {
                table = table.withClusteringColumn((String)key.get("name"), this.decodeType(key.get("type")));
            }
        }
        if ((values = (List)dataFetchingEnvironment.getArgument("values")) != null) {
            for (Object key : values) {
                table = table.withColumn((String)key.get("name"), this.decodeType(key.get("type")));
            }
        }
        CreateTableWithOptions options = null;
        if (clusteringKeys != null) {
            for (Map key : clusteringKeys) {
                if (options == null) {
                    options = (CreateTableWithOptions)table.withClusteringOrder((String)key.get("name"), this.decodeClusteringOrder((String)key.get("order")));
                    continue;
                }
                options = (CreateTableWithOptions)options.withClusteringOrder((String)key.get("name"), this.decodeClusteringOrder((String)key.get("order")));
            }
        }
        String query = options != null ? options.build().getQuery() : table.build().getQuery();
        return query;
    }

    private ClusteringOrder decodeClusteringOrder(String order) {
        return ClusteringOrder.valueOf((String)order);
    }
}

