/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.fetchers;

import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.ClientState;
import io.stargate.db.Persistence;
import io.stargate.db.QueryState;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.fetchers.SchemaFetcher;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateKeyspaceFetcher
implements SchemaFetcher {
    private final Persistence<?, ?, ?> persistence;
    private final AuthenticationService authenticationService;

    public CreateKeyspaceFetcher(Persistence<?, ?, ?> persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        String keyspaceName = (String)dataFetchingEnvironment.getArgument("name");
        CreateKeyspaceStart start = SchemaBuilder.createKeyspace((String)keyspaceName);
        boolean ifNotExists = (Boolean)dataFetchingEnvironment.getArgumentOrDefault("ifNotExists", (Object)Boolean.FALSE);
        if (ifNotExists) {
            start = start.ifNotExists();
        }
        Integer replicas = (Integer)dataFetchingEnvironment.getArgument("replicas");
        List datacenters = (List)dataFetchingEnvironment.getArgument("datacenters");
        if (replicas == null && datacenters == null) {
            throw new IllegalArgumentException("You must specify either replicas or datacenters");
        }
        if (replicas != null && datacenters != null) {
            throw new IllegalArgumentException("You can't specify both replicas and datacenters");
        }
        if (replicas != null) {
            return ((CreateKeyspace)start.withSimpleStrategy(replicas.intValue())).asCql();
        }
        return ((CreateKeyspace)start.withNetworkTopologyStrategy(this.parseDatacenters(datacenters))).asCql();
    }

    private Map<String, Integer> parseDatacenters(List<Map<String, Object>> datacenters) {
        assert (datacenters != null);
        if (datacenters.isEmpty()) {
            throw new IllegalArgumentException("datacenters must contain at least one element");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map<String, Object> datacenter : datacenters) {
            String dcName = (String)datacenter.get("name");
            Integer dcReplicas = (Integer)datacenter.getOrDefault("replicas", 3);
            result.put(dcName, dcReplicas);
        }
        return result;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        StoredCredentials storedCredentials = this.authenticationService.validateToken(token);
        ClientState clientState = this.persistence.newClientState(storedCredentials.getRoleName());
        QueryState queryState = this.persistence.newQueryState(clientState);
        DataStore dataStore = this.persistence.newDataStore(queryState, null);
        dataStore.query(this.getQuery(environment), new Object[0]).get();
        return true;
    }
}

