/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.core;

import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.ClientState;
import io.stargate.db.Persistence;
import io.stargate.db.QueryState;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeyspaceFetcher {
    public Persistence persistence;
    private AuthenticationService authenticationService;

    public KeyspaceFetcher(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    private List formatResult(Set<Keyspace> keyspaces, DataFetchingEnvironment environment) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Keyspace keyspace : keyspaces) {
            list.add(this.formatResult(keyspace, environment));
        }
        return list;
    }

    private Map<String, Object> formatResult(Keyspace keyspace, DataFetchingEnvironment environment) {
        String tableName;
        Table table;
        SelectedField tableField;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)keyspace.name());
        if (environment.getSelectionSet().getField("tables") != null) {
            builder.put((Object)"tables", (Object)this.buildTables(keyspace.tables()));
        }
        if ((tableField = environment.getSelectionSet().getField("table")) != null && (table = keyspace.table(tableName = (String)tableField.getArguments().get("name"))) != null) {
            builder.put((Object)"table", (Object)this.buildTable(table));
        }
        builder.put((Object)"dcs", (Object)this.buildDcs(keyspace));
        return builder.build();
    }

    private List buildDcs(Keyspace keyspace) {
        ArrayList<ImmutableMap> list = new ArrayList<ImmutableMap>();
        for (Map.Entry entries : keyspace.replication().entrySet()) {
            if (((String)entries.getKey()).equals("class") || ((String)entries.getKey()).equals("replication_factor")) continue;
            list.add(ImmutableMap.of((Object)"name", entries.getKey(), (Object)"replicas", entries.getValue()));
        }
        return list;
    }

    private List buildTables(Set<Table> tables) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Table table : tables) {
            list.add(this.buildTable(table));
        }
        return list;
    }

    private Map buildTable(Table table) {
        return ImmutableMap.of((Object)"name", (Object)table.name(), (Object)"columns", (Object)this.buildColumns(table.columns()));
    }

    private List buildColumns(List<Column> columns) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Column column : columns) {
            list.add(this.buildColumn(column));
        }
        return list;
    }

    private Map buildColumn(Column column) {
        return ImmutableMap.of((Object)"kind", (Object)this.buildColumnKind(column), (Object)"name", (Object)column.name(), (Object)"type", (Object)this.buildDataType(column.type()));
    }

    private Object buildDataType(Column.ColumnType columntype) {
        if (columntype.isParameterized()) {
            return ImmutableMap.of((Object)"basic", (Object)this.buildBasicType(columntype), (Object)"info", (Object)this.buildDataTypeInfo(columntype));
        }
        return ImmutableMap.of((Object)"basic", (Object)this.buildBasicType(columntype));
    }

    private Object buildDataTypeInfo(Column.ColumnType columntype) {
        if (columntype.isParameterized()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Column.ColumnType type : columntype.parameters()) {
                list.add(this.buildDataType(type));
            }
            return ImmutableMap.of((Object)"subTypes", list);
        }
        return null;
    }

    private Object buildBasicType(Column.ColumnType columntype) {
        return columntype.rawType().name().toUpperCase();
    }

    private Object buildColumnKind(Column column) {
        switch (column.kind()) {
            case PartitionKey: {
                return "PARTITION";
            }
            case Clustering: {
                return "CLUSTERING";
            }
            case Regular: {
                return "REGULAR";
            }
            case Static: {
                return "STATIC";
            }
        }
        return "UNKNOWN";
    }

    public class KeyspacesFetcher
    implements DataFetcher {
        public Object get(DataFetchingEnvironment environment) throws Exception {
            HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
            String token = httpAwareContext.getAuthToken();
            StoredCredentials storedCredentials = KeyspaceFetcher.this.authenticationService.validateToken(token);
            ClientState clientState = KeyspaceFetcher.this.persistence.newClientState(storedCredentials.getRoleName());
            QueryState queryState = KeyspaceFetcher.this.persistence.newQueryState(clientState);
            DataStore dataStore = KeyspaceFetcher.this.persistence.newDataStore(queryState, null);
            return KeyspaceFetcher.this.formatResult(dataStore.schema().keyspaces(), environment);
        }
    }

    public class KeyspaceByNameFetcher
    implements DataFetcher {
        public Object get(DataFetchingEnvironment environment) throws Exception {
            HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
            String token = httpAwareContext.getAuthToken();
            StoredCredentials storedCredentials = KeyspaceFetcher.this.authenticationService.validateToken(token);
            ClientState clientState = KeyspaceFetcher.this.persistence.newClientState(storedCredentials.getRoleName());
            QueryState queryState = KeyspaceFetcher.this.persistence.newQueryState(clientState);
            DataStore dataStore = KeyspaceFetcher.this.persistence.newDataStore(queryState, null);
            String keyspaceName = (String)environment.getArgument("name");
            Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
            if (keyspace == null) {
                return null;
            }
            return KeyspaceFetcher.this.formatResult(keyspace, environment);
        }
    }
}

