/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.core;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.ClientState;
import io.stargate.db.Persistence;
import io.stargate.db.QueryState;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.graphql.core.NameMapping;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class DataFetchers {
    private final NameMapping nameMapping;
    private final Persistence persistence;
    private AuthenticationService authenticationService;

    public DataFetchers(Persistence persistence, Keyspace keyspace, NameMapping nameMapping, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        this.nameMapping = nameMapping;
    }

    private List<Condition> buildIfConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Condition> clause = new ArrayList<Condition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                switch (condition.getKey()) {
                    case "eq": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "notEq": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isNotEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "gt": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isGreaterThan((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "gte": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isGreaterThanOrEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "lt": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isLessThan((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "lte": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isLessThanOrEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "in": {
                        clause.add((Condition)Condition.column((String)this.getDBColumnName(table, clauseEntry.getKey())).in(this.buildListLiterals(condition.getValue())));
                        break;
                    }
                }
            }
        }
        return clause;
    }

    private List<Relation> buildFilterConditions(Table table, Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                switch (condition.getKey()) {
                    case "eq": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "notEq": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isNotEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "gt": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isGreaterThan((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "gte": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isGreaterThanOrEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "lt": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isLessThan((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "lte": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).isLessThanOrEqualTo((Term)QueryBuilder.literal((Object)condition.getValue())));
                        break;
                    }
                    case "in": {
                        relations.add((Relation)Relation.column((String)this.getDBColumnName(table, clauseEntry.getKey())).in(this.buildListLiterals(condition.getValue())));
                        break;
                    }
                }
            }
        }
        return relations;
    }

    private List<Term> buildListLiterals(Object o) {
        ArrayList<Term> literals = new ArrayList<Term>();
        if (o instanceof List) {
            List values = (List)o;
            for (Object value : values) {
                literals.add((Term)QueryBuilder.literal(value));
            }
        } else {
            literals.add((Term)QueryBuilder.literal((Object)o));
        }
        return literals;
    }

    private List<Relation> buildClause(Table table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildFilterConditions(table, columnList);
        }
        Map value = (Map)environment.getArgument("value");
        ArrayList<Relation> relations = new ArrayList<Relation>();
        if (value == null) {
            return ImmutableList.of();
        }
        for (Map.Entry entry : value.entrySet()) {
            relations.add((Relation)Relation.column((String)this.getDBColumnName(table, (String)entry.getKey())).isEqualTo((Term)QueryBuilder.literal(entry.getValue())));
        }
        return relations;
    }

    public String getDBColumnName(Table table, String column) {
        return ((Column)this.nameMapping.getColumnName(table).inverse().get((Object)column)).name();
    }

    class QueryDataFetcher
    implements DataFetcher {
        private final Table table;

        public QueryDataFetcher(Table table) {
            this.table = table;
        }

        public Object get(DataFetchingEnvironment environment) throws ExecutionException, InterruptedException, UnauthorizedException {
            String statement = this.buildQuery(environment);
            HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
            String token = httpAwareContext.getAuthToken();
            StoredCredentials storedCredentials = DataFetchers.this.authenticationService.validateToken(token);
            ClientState clientState = DataFetchers.this.persistence.newClientState(storedCredentials.getRoleName());
            QueryState queryState = DataFetchers.this.persistence.newQueryState(clientState);
            DataStore dataStore = DataFetchers.this.persistence.newDataStore(queryState, null);
            CompletableFuture rs = dataStore.query(statement, new Object[0]);
            ResultSet resultSet = (ResultSet)rs.get();
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
            for (Row row : resultSet.rows()) {
                results.add(this.row2Map(row));
            }
            return ImmutableMap.of((Object)"values", results);
        }

        public Map<String, Object> row2Map(Row row) {
            List defs = row.columns();
            HashMap<String, Object> map = new HashMap<String, Object>(defs.size());
            for (Column column : defs) {
                if (!row.has(column)) continue;
                Column columnMetadata = this.table.column(column.name());
                map.put((String)DataFetchers.this.nameMapping.getColumnName(this.table).get((Object)columnMetadata), this.transformObjectToJavaObject(row.getValue(column.name())));
            }
            return map;
        }

        private Object transformObjectToJavaObject(Object o) {
            if (o instanceof Object[]) {
                return new ArrayList<Object>(Arrays.asList((Object[])o));
            }
            return o;
        }

        private String buildQuery(DataFetchingEnvironment environment) {
            Select select = ((Select)QueryBuilder.selectFrom((String)this.table.keyspace(), (String)this.table.name()).columns(this.buildQueryColumns(environment)).where((Iterable)DataFetchers.this.buildClause(this.table, environment))).orderBy(this.buildOrderBy(environment));
            if (environment.containsArgument("options")) {
                Map options = (Map)environment.getArgument("options");
                if (options.containsKey("limit")) {
                    select = select.limit(((Integer)options.get("limit")).intValue());
                }
                if (options.containsKey("pageSize")) {
                    // empty if block
                }
                if (options.containsKey("pageState")) {
                    // empty if block
                }
                if (options.containsKey("consistency")) {
                    // empty if block
                }
            }
            return select.asCql();
        }

        private Map<String, ClusteringOrder> buildOrderBy(DataFetchingEnvironment environment) {
            if (environment.containsArgument("orderBy")) {
                LinkedHashMap<String, ClusteringOrder> orderMap = new LinkedHashMap<String, ClusteringOrder>();
                List orderList = (List)environment.getArgument("orderBy");
                for (int i = 0; i < orderList.size(); ++i) {
                    String order = (String)orderList.get(i);
                    int split = order.lastIndexOf("_");
                    String column = order.substring(0, split);
                    boolean desc = order.substring(split + 1).equals("DESC");
                    orderMap.put(DataFetchers.this.getDBColumnName(this.table, column), desc ? ClusteringOrder.DESC : ClusteringOrder.ASC);
                }
                return orderMap;
            }
            return ImmutableMap.of();
        }

        private List<String> buildQueryColumns(DataFetchingEnvironment environment) {
            if (environment.getSelectionSet().contains("values")) {
                SelectedField field = environment.getSelectionSet().getField("values");
                ArrayList<String> fields = new ArrayList<String>();
                for (SelectedField selectedField : field.getSelectionSet().getFields()) {
                    String column;
                    if ("__typename".equals(selectedField.getName()) || this.table.column(column = DataFetchers.this.getDBColumnName(this.table, selectedField.getName())) == null) continue;
                    fields.add(column);
                }
                return fields;
            }
            return ImmutableList.of();
        }
    }

    class DeleteMutationDataFetcher
    extends AbstractMutationDataFetcher {
        public DeleteMutationDataFetcher(Table table) {
            super(table);
        }

        @Override
        public String buildStatement(Table table, DataFetchingEnvironment environment, DataStore dataStore) {
            Delete delete = (Delete)((Delete)QueryBuilder.deleteFrom((String)table.keyspace(), (String)table.name()).where((Iterable)DataFetchers.this.buildClause(table, environment))).if_((Iterable)DataFetchers.this.buildIfConditions(table, (Map)environment.getArgument("ifCondition")));
            if (environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && ((Boolean)environment.getArgument("ifExists")).booleanValue()) {
                delete = (Delete)delete.ifExists();
            }
            if (environment.containsArgument("options") && environment.getArgument("options") != null) {
                Map options = (Map)environment.getArgument("options");
                if (options.containsKey("consistency")) {
                    // empty if block
                }
                if (options.containsKey("serialConsistency")) {
                    // empty if block
                }
            }
            return delete.asCql();
        }
    }

    class UpdateMutationDataFetcher
    extends AbstractMutationDataFetcher {
        public UpdateMutationDataFetcher(Table table) {
            super(table);
        }

        @Override
        public String buildStatement(Table table, DataFetchingEnvironment environment, DataStore dataStore) {
            Map options;
            UpdateStart updateStart = QueryBuilder.update((String)table.keyspace(), (String)table.name());
            if (environment.containsArgument("options") && environment.getArgument("options") != null && (options = (Map)environment.getArgument("options")).containsKey("ttl") && options.get("ttl") != null) {
                updateStart = updateStart.usingTtl(((Integer)options.get("ttl")).intValue());
            }
            Update update = (Update)((Update)updateStart.set(this.buildAssignments(table, environment)).where(this.buildPkCKWhere(table, environment))).if_((Iterable)DataFetchers.this.buildIfConditions(table, (Map)environment.getArgument("ifCondition")));
            if (environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && ((Boolean)environment.getArgument("ifExists")).booleanValue()) {
                update = (Update)update.ifExists();
            }
            if (environment.containsArgument("options") && environment.getArgument("options") != null) {
                Map options2 = (Map)environment.getArgument("options");
                if (!options2.containsKey("consistency") || options2.get("consistency") != null) {
                    // empty if block
                }
                if (!options2.containsKey("serialConsistency") || options2.get("consistency") != null) {
                    // empty if block
                }
            }
            return update.asCql();
        }

        private List<Relation> buildPkCKWhere(Table table, DataFetchingEnvironment environment) {
            Map value = (Map)environment.getArgument("value");
            ArrayList<Relation> relations = new ArrayList<Relation>();
            for (Map.Entry entry : value.entrySet()) {
                Column columnMetadata = table.column(DataFetchers.this.getDBColumnName(table, (String)entry.getKey()));
                if (!table.partitionKeyColumns().contains(columnMetadata) && !table.clusteringKeyColumns().contains(columnMetadata)) continue;
                relations.add((Relation)Relation.column((String)DataFetchers.this.getDBColumnName(table, (String)entry.getKey())).isEqualTo((Term)QueryBuilder.literal(entry.getValue())));
            }
            return relations;
        }

        private List<Assignment> buildAssignments(Table table, DataFetchingEnvironment environment) {
            Map value = (Map)environment.getArgument("value");
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            for (Map.Entry entry : value.entrySet()) {
                Column columnMetadata = table.column(DataFetchers.this.getDBColumnName(table, (String)entry.getKey()));
                if (table.partitionKeyColumns().contains(columnMetadata) || table.clusteringKeyColumns().contains(columnMetadata)) continue;
                assignments.add(Assignment.setColumn((String)DataFetchers.this.getDBColumnName(table, (String)entry.getKey()), (Term)QueryBuilder.literal(entry.getValue())));
            }
            return assignments;
        }
    }

    class InsertMutationDataFetcher
    extends AbstractMutationDataFetcher {
        public InsertMutationDataFetcher(Table table) {
            super(table);
        }

        @Override
        public String buildStatement(Table table, DataFetchingEnvironment environment, DataStore dataStore) {
            RegularInsert insert = QueryBuilder.insertInto((String)table.keyspace(), (String)table.name()).values(this.buildInsertValues(environment));
            if (environment.containsArgument("ifNotExists") && environment.getArgument("ifNotExists") != null && ((Boolean)environment.getArgument("ifNotExists")).booleanValue()) {
                insert = insert.ifNotExists();
            }
            if (environment.containsArgument("options") && environment.getArgument("options") != null) {
                Map options = (Map)environment.getArgument("options");
                if (options.containsKey("ttl") && options.get("ttl") != null) {
                    insert = insert.usingTtl(((Integer)options.get("ttl")).intValue());
                }
                if (!options.containsKey("consistency") || options.get("consistency") != null) {
                    // empty if block
                }
                if (!options.containsKey("serialConsistency") || options.get("serialConsistency") != null) {
                    // empty if block
                }
            }
            return insert.asCql();
        }

        private Map<String, Term> buildInsertValues(DataFetchingEnvironment environment) {
            Map value = (Map)environment.getArgument("value");
            Preconditions.checkNotNull((Object)value, (Object)"Insert statement must contain at least one field");
            LinkedHashMap<String, Term> insertMap = new LinkedHashMap<String, Term>();
            for (Map.Entry entry : value.entrySet()) {
                insertMap.put(DataFetchers.this.getDBColumnName(this.table, (String)entry.getKey()), (Term)QueryBuilder.literal(entry.getValue()));
            }
            return insertMap;
        }
    }

    abstract class AbstractMutationDataFetcher
    implements DataFetcher {
        protected final Table table;

        public AbstractMutationDataFetcher(Table table) {
            this.table = table;
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
            String token = httpAwareContext.getAuthToken();
            StoredCredentials storedCredentials = DataFetchers.this.authenticationService.validateToken(token);
            ClientState clientState = DataFetchers.this.persistence.newClientState(storedCredentials.getRoleName());
            QueryState queryState = DataFetchers.this.persistence.newQueryState(clientState);
            DataStore dataStore = DataFetchers.this.persistence.newDataStore(queryState, null);
            String statement = this.buildStatement(this.table, environment, dataStore);
            return dataStore.query(statement, new Object[0]).thenApply(resultSet -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
        }

        public abstract String buildStatement(Table var1, DataFetchingEnvironment var2, DataStore var3);
    }
}

