/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.GraphQLRootObjectBuilder;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.InstrumentationProvider;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.execution.instrumentation.NoOpInstrumentationProvider;
import graphql.kickstart.servlet.AbstractGraphQLHttpServlet;
import graphql.kickstart.servlet.OsgiGraphQLHttpServletConfiguration;
import graphql.kickstart.servlet.config.DefaultGraphQLSchemaServletProvider;
import graphql.kickstart.servlet.config.GraphQLSchemaServletProvider;
import graphql.kickstart.servlet.context.DefaultGraphQLServletContextBuilder;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import graphql.kickstart.servlet.core.DefaultGraphQLRootObjectBuilder;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.kickstart.servlet.core.GraphQLServletRootObjectBuilder;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import graphql.kickstart.servlet.osgi.GraphQLCodeRegistryProvider;
import graphql.kickstart.servlet.osgi.GraphQLMutationProvider;
import graphql.kickstart.servlet.osgi.GraphQLProvider;
import graphql.kickstart.servlet.osgi.GraphQLQueryProvider;
import graphql.kickstart.servlet.osgi.GraphQLSubscriptionProvider;
import graphql.kickstart.servlet.osgi.GraphQLTypesProvider;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={HttpServlet.class, Servlet.class}, property={"service.description=GraphQL HTTP Servlet"})
@Designate(ocd=OsgiGraphQLHttpServletConfiguration.class, factory=true)
public class OsgiGraphQLHttpServlet
extends AbstractGraphQLHttpServlet {
    private final List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    private final List<GraphQLSubscriptionProvider> subscriptionProviders = new ArrayList<GraphQLSubscriptionProvider>();
    private final List<GraphQLTypesProvider> typesProviders = new ArrayList<GraphQLTypesProvider>();
    private final GraphQLQueryInvoker queryInvoker;
    private final GraphQLInvocationInputFactory invocationInputFactory;
    private final GraphQLObjectMapper graphQLObjectMapper;
    private GraphQLServletContextBuilder contextBuilder = new DefaultGraphQLServletContextBuilder();
    private GraphQLServletRootObjectBuilder rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider();
    private InstrumentationProvider instrumentationProvider = new NoOpInstrumentationProvider();
    private GraphQLErrorHandler errorHandler = new DefaultGraphQLErrorHandler();
    private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    private GraphQLCodeRegistryProvider codeRegistryProvider = () -> GraphQLCodeRegistry.newCodeRegistry().build();
    private GraphQLSchemaServletProvider schemaProvider;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> updateFuture;
    private int schemaUpdateDelay;

    public OsgiGraphQLHttpServlet() {
        this.updateSchema();
        this.queryInvoker = GraphQLQueryInvoker.newBuilder().withPreparsedDocumentProvider(this::getPreparsedDocumentProvider).withInstrumentation(() -> this.getInstrumentationProvider().getInstrumentation()).withExecutionStrategyProvider(this::getExecutionStrategyProvider).build();
        this.invocationInputFactory = GraphQLInvocationInputFactory.newBuilder(this::getSchemaProvider).withGraphQLContextBuilder(this::getContextBuilder).withGraphQLRootObjectBuilder(this::getRootObjectBuilder).build();
        this.graphQLObjectMapper = GraphQLObjectMapper.newBuilder().withGraphQLErrorHandler(this::getErrorHandler).build();
    }

    @Activate
    public void activate(Config config) {
        this.schemaUpdateDelay = config.schema_update_delay();
        if (this.schemaUpdateDelay != 0) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    protected GraphQLQueryInvoker getQueryInvoker() {
        return this.queryInvoker;
    }

    @Override
    protected GraphQLInvocationInputFactory getInvocationInputFactory() {
        return this.invocationInputFactory;
    }

    @Override
    protected GraphQLObjectMapper getGraphQLObjectMapper() {
        return this.graphQLObjectMapper;
    }

    @Override
    protected boolean isAsyncServletMode() {
        return false;
    }

    protected void updateSchema() {
        if (this.schemaUpdateDelay == 0) {
            this.doUpdateSchema();
        } else {
            if (this.updateFuture != null) {
                this.updateFuture.cancel(true);
            }
            this.updateFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    OsgiGraphQLHttpServlet.this.doUpdateSchema();
                }
            }, (long)this.schemaUpdateDelay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doUpdateSchema() {
        void var3_7;
        GraphQLObjectType.Builder queryTypeBuilder = GraphQLObjectType.newObject().name("Query").description("Root query type");
        for (GraphQLQueryProvider graphQLQueryProvider : this.queryProviders) {
            if (graphQLQueryProvider.getQueries() == null || graphQLQueryProvider.getQueries().isEmpty()) continue;
            graphQLQueryProvider.getQueries().forEach(arg_0 -> ((GraphQLObjectType.Builder)queryTypeBuilder).field(arg_0));
        }
        HashSet types = new HashSet();
        for (GraphQLTypesProvider typesProvider : this.typesProviders) {
            types.addAll(typesProvider.getTypes());
        }
        Object var3_5 = null;
        if (!this.mutationProviders.isEmpty()) {
            GraphQLObjectType.Builder mutationTypeBuilder = GraphQLObjectType.newObject().name("Mutation").description("Root mutation type");
            for (GraphQLMutationProvider provider : this.mutationProviders) {
                provider.getMutations().forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationTypeBuilder).field(arg_0));
            }
            if (!mutationTypeBuilder.build().getFieldDefinitions().isEmpty()) {
                GraphQLObjectType graphQLObjectType = mutationTypeBuilder.build();
            }
        }
        GraphQLObjectType subscriptionType = null;
        if (!this.subscriptionProviders.isEmpty()) {
            GraphQLObjectType.Builder subscriptionTypeBuilder = GraphQLObjectType.newObject().name("Subscription").description("Root subscription type");
            for (GraphQLSubscriptionProvider provider : this.subscriptionProviders) {
                provider.getSubscriptions().forEach(arg_0 -> ((GraphQLObjectType.Builder)subscriptionTypeBuilder).field(arg_0));
            }
            if (!subscriptionTypeBuilder.build().getFieldDefinitions().isEmpty()) {
                subscriptionType = subscriptionTypeBuilder.build();
            }
        }
        this.schemaProvider = new DefaultGraphQLSchemaServletProvider(GraphQLSchema.newSchema().query(queryTypeBuilder.build()).mutation((GraphQLObjectType)var3_7).subscription(subscriptionType).additionalTypes(types).codeRegistry(this.codeRegistryProvider.getCodeRegistry()).build());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.add((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.add((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.add((GraphQLSubscriptionProvider)provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.add((GraphQLTypesProvider)provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.codeRegistryProvider = (GraphQLCodeRegistryProvider)provider;
        }
        this.updateSchema();
    }

    public void unbindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.remove(provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.remove(provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.remove(provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.remove(provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.codeRegistryProvider = () -> GraphQLCodeRegistry.newCodeRegistry().build();
        }
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.remove(mutationProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.subscriptionProviders.add(subscriptionProvider);
        this.updateSchema();
    }

    public void unbindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.subscriptionProviders.remove(subscriptionProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.add(typesProvider);
        this.updateSchema();
    }

    public void unbindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.remove(typesProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindServletListener(GraphQLServletListener listener) {
        this.addListener(listener);
    }

    public void unbindServletListener(GraphQLServletListener listener) {
        this.removeListener(listener);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setContextProvider(GraphQLServletContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    public void unsetContextProvider(GraphQLServletContextBuilder contextBuilder) {
        this.contextBuilder = new DefaultGraphQLServletContextBuilder();
    }

    public void unsetRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = new DefaultExecutionStrategyProvider();
    }

    public void unsetInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = new NoOpInstrumentationProvider();
    }

    public void unsetErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = new DefaultGraphQLErrorHandler();
    }

    public void unsetPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void bindCodeRegistryProvider(GraphQLCodeRegistryProvider graphQLCodeRegistryProvider) {
        this.codeRegistryProvider = graphQLCodeRegistryProvider;
        this.updateSchema();
    }

    public void unbindCodeRegistryProvider(GraphQLCodeRegistryProvider graphQLCodeRegistryProvider) {
        this.codeRegistryProvider = () -> GraphQLCodeRegistry.newCodeRegistry().build();
        this.updateSchema();
    }

    public GraphQLServletContextBuilder getContextBuilder() {
        return this.contextBuilder;
    }

    public GraphQLServletRootObjectBuilder getRootObjectBuilder() {
        return this.rootObjectBuilder;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setRootObjectBuilder(GraphQLServletRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = rootObjectBuilder;
    }

    public ExecutionStrategyProvider getExecutionStrategyProvider() {
        return this.executionStrategyProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = provider;
    }

    public InstrumentationProvider getInstrumentationProvider() {
        return this.instrumentationProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = provider;
    }

    public GraphQLErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public PreparsedDocumentProvider getPreparsedDocumentProvider() {
        return this.preparsedDocumentProvider;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = preparsedDocumentProvider;
    }

    public GraphQLSchemaServletProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    static @interface Config {
        public int schema_update_delay() default 0;
    }
}

