/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.HttpRequestHandler;
import graphql.kickstart.servlet.HttpRequestHandlerImpl;
import graphql.schema.GraphQLSchema;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.EventListener;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.core.GqlKeyspaceSchema;
import io.stargate.graphql.graphqlservlet.CassandraUnboxingGraphqlErrorHandler;
import io.stargate.graphql.graphqlservlet.GraphqlCustomContextBuilder;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGraphQLServlet
extends HttpServlet
implements Servlet,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CustomGraphQLServlet.class);
    private static final Pattern KEYSPACE_NAME_PATTERN = Pattern.compile("\\w+");
    private final Persistence<?, ?, ?> persistence;
    private final AuthenticationService authenticationService;
    private final String defaultKeyspace;
    private final ConcurrentMap<String, HttpRequestHandler> keyspaceHandlers;

    public CustomGraphQLServlet(Persistence<?, ?, ?> persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        DataStore dataStore = persistence.newDataStore(null, null);
        this.defaultKeyspace = CustomGraphQLServlet.findDefaultKeyspace(dataStore);
        this.keyspaceHandlers = CustomGraphQLServlet.initKeyspaceHandlers(persistence, dataStore, authenticationService);
        persistence.registerEventListener((EventListener)this);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) {
        String keyspaceName = this.getKeyspaceName(request);
        if (keyspaceName == null) {
            this.failOnNoDefaultKeyspace(response);
        } else if (!KEYSPACE_NAME_PATTERN.matcher(keyspaceName).matches()) {
            response.setStatus(500);
        } else {
            HttpRequestHandler requestHandler = (HttpRequestHandler)this.keyspaceHandlers.get(keyspaceName);
            if (requestHandler == null) {
                this.failOnUnknownKeyspace(keyspaceName, response);
            } else {
                try {
                    requestHandler.handle(request, response);
                }
                catch (Exception e) {
                    LOG.error("Error processing a GraphQL request", (Throwable)e);
                    response.setStatus(500);
                }
            }
        }
    }

    public String getKeyspaceName(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null || path.length() < 2) {
            return this.defaultKeyspace;
        }
        return path.substring(1).toLowerCase();
    }

    private void failOnNoDefaultKeyspace(HttpServletResponse response) {
        String message = "No keyspace specified, and no default keyspace could be determined";
        this.failWith404(response, message);
    }

    private void failOnUnknownKeyspace(String keyspaceName, HttpServletResponse response) {
        this.failWith404(response, "Unknown keyspace " + keyspaceName);
    }

    private void failWith404(HttpServletResponse response, String message) {
        response.setStatus(404);
        try {
            response.getWriter().println(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String findDefaultKeyspace(DataStore dataStore) {
        try {
            CompletableFuture query = dataStore.query("select writetime(durable_writes) as wt, keyspace_name from system_schema.keyspaces", Optional.of(ConsistencyLevel.LOCAL_QUORUM), new Object[0]);
            ResultSet resultSet = (ResultSet)query.get();
            Column writetimeColumn = Column.create((String)"wt", (Column.ColumnType)Column.Type.Counter);
            Optional<Row> first = resultSet.rows().stream().filter(r -> r.has("wt")).filter(r -> r.getLong(writetimeColumn) > 0L).filter(r -> {
                String keyspaceName = r.getString("keyspace_name");
                return !keyspaceName.equals("system") && !keyspaceName.equals("data_endpoint_auth") && !keyspaceName.equals("solr_admin") && !keyspaceName.startsWith("system_") && !keyspaceName.startsWith("dse_");
            }).min(Comparator.comparing(r -> r.getLong(writetimeColumn)));
            String defaultKeyspace = first.map(row -> row.getString("keyspace_name")).orElse(null);
            LOG.debug("Using default keyspace {}", (Object)defaultKeyspace);
            return defaultKeyspace;
        }
        catch (Exception e) {
            LOG.warn("Unable to get default keyspace", (Throwable)e);
            return null;
        }
    }

    private static ConcurrentMap<String, HttpRequestHandler> initKeyspaceHandlers(Persistence<?, ?, ?> persistence, DataStore dataStore, AuthenticationService authenticationService) {
        ConcurrentHashMap<String, HttpRequestHandler> map = new ConcurrentHashMap<String, HttpRequestHandler>();
        for (Keyspace keyspace : dataStore.schema().keyspaces()) {
            String keyspaceName = keyspace.name().toLowerCase();
            try {
                HttpRequestHandler handler = CustomGraphQLServlet.buildKeyspaceHandler(keyspace, persistence, authenticationService);
                map.put(keyspaceName, handler);
                LOG.debug("Added handler for {}", (Object)keyspaceName);
            }
            catch (Exception e) {
                LOG.warn("Could not create handler for " + keyspaceName, (Throwable)e);
            }
        }
        return map;
    }

    private void addOrReplaceKeyspaceHandler(String keyspaceName, String reason, String ... reasonArguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Refreshing handler for keyspace {} because {}", (Object)keyspaceName, (Object)String.format(reason, reasonArguments));
        }
        try {
            DataStore dataStore = this.persistence.newDataStore(null, null);
            Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
            this.keyspaceHandlers.put(keyspaceName, CustomGraphQLServlet.buildKeyspaceHandler(keyspace, this.persistence, this.authenticationService));
            LOG.debug("Done refreshing handler for keyspace {}", (Object)keyspaceName);
        }
        catch (Exception e) {
            LOG.error("Error while refreshing handler for keyspace {}", (Object)keyspaceName, (Object)e);
        }
    }

    private static HttpRequestHandler buildKeyspaceHandler(Keyspace keyspace, Persistence<?, ?, ?> persistence, AuthenticationService authenticationService) {
        GraphQLSchema schema = new GqlKeyspaceSchema(persistence, authenticationService, keyspace).build().build();
        GraphQLConfiguration configuration = GraphQLConfiguration.with(schema).with(new GraphqlCustomContextBuilder()).with(GraphQLObjectMapper.newBuilder().withGraphQLErrorHandler((GraphQLErrorHandler)new CassandraUnboxingGraphqlErrorHandler()).build()).build();
        return new HttpRequestHandlerImpl(configuration);
    }

    public void onCreateKeyspace(String keyspaceName) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "it was created", new String[0]);
    }

    public void onDropKeyspace(String keyspaceName) {
        HttpRequestHandler removed = (HttpRequestHandler)this.keyspaceHandlers.remove(keyspaceName);
        if (removed != null) {
            LOG.debug("Removing handler for keyspace {} because it was dropped", (Object)keyspaceName);
        } else {
            LOG.warn("Keyspace {} was dropped, but we didn't have a handler for it,ignoring but that's unexpected", (Object)keyspaceName);
        }
    }

    public void onCreateTable(String keyspaceName, String table) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "table %s was created", table);
    }

    public void onCreateView(String keyspaceName, String view) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "view %s was created", view);
    }

    public void onCreateType(String keyspaceName, String type) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "type %s was created", type);
    }

    public void onCreateFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "function %s was created", function);
    }

    public void onCreateAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "aggregate %s was created", aggregate);
    }

    public void onAlterTable(String keyspaceName, String table) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "table %s was altered", table);
    }

    public void onAlterView(String keyspaceName, String view) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "view %s was altered", view);
    }

    public void onAlterType(String keyspaceName, String type) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "type %s was altered", type);
    }

    public void onAlterFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "function %s was altered", function);
    }

    public void onAlterAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "aggregate %s was altered", aggregate);
    }

    public void onDropTable(String keyspaceName, String table) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "table %s was dropped", table);
    }

    public void onDropView(String keyspaceName, String view) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "view %s was dropped", view);
    }

    public void onDropType(String keyspaceName, String type) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "type %s was dropped", type);
    }

    public void onDropFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "function %s was dropped", function);
    }

    public void onDropAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.addOrReplaceKeyspaceHandler(keyspaceName, "aggregate %s was dropped", aggregate);
    }
}

