/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.fetchers;

import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.db.ClientState;
import io.stargate.db.Persistence;
import io.stargate.db.QueryState;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.fetchers.SchemaFetcher;
import io.stargate.graphql.graphqlservlet.HTTPAwareContextImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AlterTableAddFetcher
implements SchemaFetcher,
DataFetcher {
    private final Persistence persistence;
    private AuthenticationService authenticationService;

    public AlterTableAddFetcher(Persistence persistence, AuthenticationService authenticationService) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        HTTPAwareContextImpl httpAwareContext = (HTTPAwareContextImpl)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        StoredCredentials storedCredentials = this.authenticationService.validateToken(token);
        ClientState clientState = this.persistence.newClientState(storedCredentials.getRoleName());
        QueryState queryState = this.persistence.newQueryState(clientState);
        DataStore dataStore = this.persistence.newDataStore(queryState, null);
        CompletableFuture resultSetSingle = dataStore.query(this.getQuery(environment), new Object[0]);
        resultSetSingle.get();
        return true;
    }

    @Override
    public String getQuery(DataFetchingEnvironment dataFetchingEnvironment) {
        AlterTableStart start = SchemaBuilder.alterTable((String)((String)dataFetchingEnvironment.getArgument("keyspaceName")), (String)((String)dataFetchingEnvironment.getArgument("tableName")));
        List toAdd = (List)dataFetchingEnvironment.getArgument("toAdd");
        if (toAdd.isEmpty()) {
            throw new IllegalArgumentException("toAdd must contain at least one element");
        }
        AlterTableAddColumnEnd table = null;
        for (Map column : toAdd) {
            if (table != null) {
                table = table.addColumn((String)column.get("name"), this.decodeType(column.get("type")));
                continue;
            }
            table = start.addColumn((String)column.get("name"), this.decodeType(column.get("type")));
        }
        return table.build().getQuery();
    }
}

