/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.core.CaseUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NameMapping {
    private final BiMap<Table, String> entityName = HashBiMap.create();
    private final Map<Table, BiMap<Column, String>> columnName = new HashMap<Table, BiMap<Column, String>>();

    public NameMapping(Set<Table> tables) {
        this.buildNames(tables);
    }

    private void buildNames(Set<Table> tables) {
        for (Table table : tables) {
            this.entityName.put((Object)table, (Object)CaseUtil.toCamel(table.name()));
            this.buildColumnNames(table);
        }
    }

    private void buildColumnNames(Table tableMetadata) {
        if (this.columnName.get(tableMetadata) == null) {
            this.columnName.put(tableMetadata, (BiMap<Column, String>)HashBiMap.create());
        }
        BiMap<Column, String> map = this.columnName.get(tableMetadata);
        for (Column column : tableMetadata.columns()) {
            map.put((Object)column, (Object)CaseUtil.toLowerCamel(column.name()));
        }
    }

    public BiMap<Table, String> getEntityName() {
        return this.entityName;
    }

    public BiMap<Column, String> getColumnName(Table table) {
        return this.columnName.get(table);
    }
}

