/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.core;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CaseUtil {
    private static final Map uppercaseAcronyms = ImmutableMap.of((Object)"ID", (Object)"ID");

    public static String toCamel(String s) {
        if (uppercaseAcronyms.containsKey(s)) {
            s = s.toLowerCase();
        }
        return CaseUtil.toCamelInitCase(s, true);
    }

    public static String toLowerCamel(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        if (uppercaseAcronyms.containsKey(s)) {
            return s.toLowerCase();
        }
        Character r = Character.valueOf(s.charAt(0));
        if (r.charValue() >= 'A' && r.charValue() <= 'Z') {
            s = String.valueOf(r).toLowerCase() + s.substring(1);
        }
        return CaseUtil.toCamelInitCase(s, false);
    }

    protected static String toCamelInitCase(String s, boolean initCase) {
        s = s.trim();
        StringBuilder n = new StringBuilder();
        boolean capNext = initCase;
        for (char v : s.toCharArray()) {
            if (v >= 'A' && v <= 'Z') {
                n.append(String.valueOf(v));
            }
            if (v >= '0' && v <= '9') {
                n.append(String.valueOf(v));
            }
            if (v >= 'a' && v <= 'z') {
                if (capNext) {
                    n.append(String.valueOf(v).toUpperCase());
                } else {
                    n.append(String.valueOf(v));
                }
            }
            capNext = v == '_' || v == ' ' || v == '-' || v == '.';
        }
        return n.toString();
    }
}

