/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import graphql.kickstart.servlet.CustomGraphQLServlet;
import graphql.kickstart.servlet.SchemaGraphQLServlet;
import io.stargate.auth.AuthenticationService;
import io.stargate.db.Persistence;
import io.stargate.graphql.PlaygroundServlet;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public class WebImpl {
    private Server server;
    private Persistence persistence;
    private AuthenticationService authenticationService;

    public void start() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(System.getProperty("stargate.listen_address"));
        connector.setPort(8080);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new CustomGraphQLServlet(this.persistence, this.authenticationService));
        context.addServlet(servletHolder, "/graphql/*");
        ServletHolder schema = new ServletHolder((Servlet)new SchemaGraphQLServlet(this.persistence, this.authenticationService));
        context.addServlet(schema, "/graphql-schema");
        ServletHolder playground = new ServletHolder((Servlet)new PlaygroundServlet());
        context.addServlet(playground, "/playground");
        FilterHolder filter = new FilterHolder();
        filter.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,PATCH");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "*");
        filter.setInitParameter("allowCredentials", "true");
        filter.setInitParameter("exposedHeaders", "Date");
        CrossOriginFilter corsFilter = new CrossOriginFilter();
        filter.setFilter((Filter)corsFilter);
        context.addFilter(CrossOriginFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        this.server.setHandler((Handler)context);
        try {
            this.server.start();
            this.server.dump((Appendable)System.err);
        }
        catch (Exception ex) {
            Logger.getLogger(WebImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

