/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.jwt.AuthnJwtService;
import io.stargate.auth.jwt.AuthzJwtService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import net.jcip.annotations.GuardedBy;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthJWTServiceActivator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(AuthJWTServiceActivator.class);
    public static final String AUTH_JWT_IDENTIFIER = "AuthJwtService";
    private static final Hashtable<String, String> props = new Hashtable();
    @GuardedBy(value="this")
    private AuthnJwtService authnJwtService;
    @GuardedBy(value="this")
    private AuthzJwtService authzJwtService;

    public synchronized void start(BundleContext context) {
        if (AUTH_JWT_IDENTIFIER.equals(System.getProperty("stargate.auth_id"))) {
            RemoteJWKSet keySource;
            log.info("Registering authnJwtService and authzJwtService in AuthnJwtService");
            String urlProvider = System.getProperty("stargate.auth.jwt_provider_url");
            if (urlProvider == null || urlProvider.equals("")) {
                throw new RuntimeException("Property `stargate.auth.jwt_provider_url` must be set");
            }
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            try {
                keySource = new RemoteJWKSet(new URL(urlProvider));
            }
            catch (MalformedURLException e) {
                log.error("Failed to create JwtValidator", (Throwable)e);
                throw new RuntimeException("Failed to create JwtValidator: " + e.getMessage(), e);
            }
            JWSAlgorithm expectedJWSAlg = JWSAlgorithm.RS256;
            JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
            jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
            this.authnJwtService = new AuthnJwtService((ConfigurableJWTProcessor<? extends SecurityContext>)jwtProcessor);
            context.registerService(AuthenticationService.class.getName(), (Object)this.authnJwtService, props);
            this.authzJwtService = new AuthzJwtService();
            context.registerService(AuthorizationService.class.getName(), (Object)this.authzJwtService, props);
        }
    }

    public void stop(BundleContext context) {
    }

    static {
        props.put("AuthIdentifier", AUTH_JWT_IDENTIFIER);
    }
}

