/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.jwt;

import io.stargate.auth.AuthenticationService;
import io.stargate.auth.Credentials;
import io.stargate.auth.PlainTextTokenSaslNegotiator;
import io.stargate.db.Authenticator;
import io.stargate.db.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextJwtTokenSaslNegotiator
extends PlainTextTokenSaslNegotiator {
    private static final Logger logger = LoggerFactory.getLogger(PlainTextJwtTokenSaslNegotiator.class);
    private final ClientInfo clientInfo;

    public PlainTextJwtTokenSaslNegotiator(AuthenticationService authentication, Authenticator.SaslNegotiator wrapped, String tokenUsername, int tokenMaxLength, ClientInfo clientInfo) {
        super(authentication, wrapped, tokenUsername, tokenMaxLength);
        this.clientInfo = clientInfo;
    }

    public boolean attemptTokenAuthentication(byte[] clientResponse) {
        try {
            Credentials credentials = PlainTextJwtTokenSaslNegotiator.decodeCredentials((byte[])clientResponse);
            if (!credentials.getUsername().equals(this.tokenUsername)) {
                return false;
            }
            char[] tmpPassword = credentials.getPassword();
            logger.trace("Attempting to validate token");
            if (tmpPassword.length > this.tokenMaxLength) {
                credentials.clearPassword();
                logger.error("Token was too long ({} characters)", (Object)tmpPassword.length);
                return false;
            }
            String password = String.valueOf(tmpPassword);
            credentials.clearPassword();
            this.authenticationSubject = this.authentication.validateToken(password, this.clientInfo);
            if (this.authenticationSubject == null) {
                logger.error("Null credentials returned from authentication service");
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Unable to validate token", (Throwable)e);
            return false;
        }
        return true;
    }
}

