/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.jwt;

import io.stargate.auth.AuthenticationService;
import io.stargate.auth.Credentials;
import io.stargate.auth.PlainTextTokenSaslNegotiator;
import io.stargate.db.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextJwtTokenSaslNegotiator
extends PlainTextTokenSaslNegotiator {
    private static final Logger logger = LoggerFactory.getLogger(PlainTextJwtTokenSaslNegotiator.class);

    public PlainTextJwtTokenSaslNegotiator(AuthenticationService authentication, Authenticator.SaslNegotiator wrapped, String tokenUsername, int tokenMaxLength) {
        super(authentication, wrapped, tokenUsername, tokenMaxLength);
    }

    public boolean attemptTokenAuthentication(byte[] clientResponse) {
        try {
            Credentials credentials = PlainTextJwtTokenSaslNegotiator.decodeCredentials((byte[])clientResponse);
            if (!credentials.getUsername().equals(this.tokenUsername)) {
                return false;
            }
            char[] tmpPassword = credentials.getPassword();
            logger.trace("Attempting to validate token");
            if (tmpPassword.length > this.tokenMaxLength) {
                credentials.clearPassword();
                logger.error("Token was too long ({} characters)", (Object)tmpPassword.length);
                return false;
            }
            String password = String.valueOf(tmpPassword);
            credentials.clearPassword();
            this.storedCredentials = this.authentication.validateToken(password);
            if (this.storedCredentials == null) {
                logger.error("Null credentials returned from authentication service");
                return false;
            }
            this.storedCredentials.setPassword(password);
        }
        catch (Exception e) {
            logger.error("Unable to validate token", (Throwable)e);
            return false;
        }
        return true;
    }
}

