/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.jwt;

import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.schema.Column;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzJwtService
implements AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthzJwtService.class);
    private final Pattern tokenPattern = Pattern.compile("\\.");

    public ResultSet authorizedDataRead(Callable<ResultSet> action, String token, String keyspace, String table, List<TypedKeyValue> typedKeyValues, SourceAPI sourceAPI) throws Exception {
        JSONObject stargateClaims = this.extractClaimsFromJWT(token);
        this.preCheckDataReadWrite(stargateClaims, typedKeyValues);
        ResultSet result = action.call();
        if (result == null) {
            return null;
        }
        return result.withRowInspector(row -> {
            if (row == null) {
                return true;
            }
            for (Column col : row.columns()) {
                String stargateClaimValue;
                if (!stargateClaims.has("x-stargate-" + col.name())) continue;
                try {
                    stargateClaimValue = stargateClaims.getString("x-stargate-" + col.name());
                }
                catch (JSONException e) {
                    log.warn("Unable to get stargate claim for x-stargate-" + col.name());
                    return false;
                }
                String columnValue = row.getString(col.name());
                if (stargateClaimValue.equals(columnValue)) continue;
                return false;
            }
            return true;
        });
    }

    public void authorizeDataRead(String token, String keyspace, String table, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeDataWrite(String token, String keyspace, String table, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeDataWrite(String token, String keyspace, String table, List<TypedKeyValue> typedKeyValues, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
        JSONObject stargateClaims = this.extractClaimsFromJWT(token);
        this.preCheckDataReadWrite(stargateClaims, typedKeyValues);
    }

    public void authorizeSchemaRead(String token, List<String> keyspaceNames, List<String> tableNames, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeSchemaWrite(String token, String keyspace, String table, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeRoleManagement(String token, String role, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeRoleManagement(String token, String role, String grantee, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizeRoleRead(String token, String role, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizePermissionManagement(String token, String resource, String grantee, Scope scope, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    public void authorizePermissionRead(String token, String role, SourceAPI sourceAPI) throws UnauthorizedException {
    }

    private JSONObject extractClaimsFromJWT(String token) throws JSONException {
        String[] parts = this.tokenPattern.split(token);
        if (parts.length < 3) {
            throw new IllegalArgumentException("Valid JWT should contain 3 parts but provided only contains " + parts.length);
        }
        String decodedPayload = new String(Base64.getUrlDecoder().decode(parts[1]));
        JSONObject payload = new JSONObject(decodedPayload);
        return payload.getJSONObject("stargate_claims");
    }

    private void preCheckDataReadWrite(JSONObject stargateClaims, List<TypedKeyValue> typedKeyValues) throws JSONException, UnauthorizedException {
        for (TypedKeyValue typedKeyValue : typedKeyValues) {
            String columnValue;
            if (!stargateClaims.has("x-stargate-" + typedKeyValue.getName())) continue;
            Column.ColumnType targetCellType = typedKeyValue.getType();
            if (!targetCellType.equals(Column.Type.Varchar) && !targetCellType.equals(Column.Type.Text)) {
                throw new IllegalArgumentException("Column must be of type text to be used for authorization");
            }
            String stargateClaimValue = stargateClaims.getString("x-stargate-" + typedKeyValue.getName());
            if (stargateClaimValue.equals(columnValue = (String)typedKeyValue.getValue())) continue;
            throw new UnauthorizedException("Not allowed to access this resource");
        }
    }
}

