/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.jwt;

import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.StoredCredentials;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.jwt.PlainTextJwtTokenSaslNegotiator;
import io.stargate.db.Authenticator;
import java.text.ParseException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnJwtService
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthnJwtService.class);
    protected static final String STARGATE_PREFIX = "x-stargate-";
    protected static final String ROLE_FIELD = "x-stargate-role";
    protected static final String CLAIMS_FIELD = "stargate_claims";
    private final ConfigurableJWTProcessor<? extends SecurityContext> jwtProcessor;

    public AuthnJwtService(ConfigurableJWTProcessor<? extends SecurityContext> jwtProcessor) {
        this.jwtProcessor = jwtProcessor;
    }

    public String createToken(String key, String secret) {
        throw new UnsupportedOperationException("Creating a token is not supported for AuthnJwtService. Tokens must be created out of band.");
    }

    public String createToken(String key) {
        throw new UnsupportedOperationException("Creating a token is not supported for AuthnJwtService. Tokens must be created out of band.");
    }

    public StoredCredentials validateToken(String token) throws UnauthorizedException {
        String roleName;
        if (Strings.isNullOrEmpty((String)token)) {
            throw new UnauthorizedException("authorization failed - missing token");
        }
        JWTClaimsSet claimsSet = this.validate(token);
        try {
            roleName = this.getRoleForJWT(claimsSet.getJSONObjectClaim(CLAIMS_FIELD));
        }
        catch (IllegalArgumentException | ParseException e) {
            logger.info("Failed to parse claim from JWT", (Throwable)e);
            throw new UnauthorizedException("Failed to parse claim from JWT", (Throwable)e);
        }
        if (Strings.isNullOrEmpty((String)roleName)) {
            throw new UnauthorizedException("JWT must have a value for x-stargate-role");
        }
        StoredCredentials storedCredentials = new StoredCredentials();
        storedCredentials.setRoleName(roleName);
        return storedCredentials;
    }

    public Authenticator.SaslNegotiator getSaslNegotiator(Authenticator.SaslNegotiator wrapped) {
        return new PlainTextJwtTokenSaslNegotiator(this, wrapped, System.getProperty("stargate.cql_token_username", "token"), Integer.parseInt(System.getProperty("stargate.cql_token_max_length", "4096")));
    }

    private JWTClaimsSet validate(String token) throws UnauthorizedException {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = this.jwtProcessor.process(token, null);
        }
        catch (JOSEException | ParseException e) {
            logger.info("Failed to process JWT", e);
            throw new UnauthorizedException("Failed to process JWT: " + e.getMessage(), e);
        }
        catch (BadJOSEException badJOSEException) {
            logger.info("Tried to validate invalid JWT", (Throwable)badJOSEException);
            throw new UnauthorizedException("Invalid JWT: " + badJOSEException.getMessage(), (Throwable)badJOSEException);
        }
        return claimsSet;
    }

    private String getRoleForJWT(Map<String, Object> stargate_claims) {
        if (stargate_claims == null) {
            throw new IllegalArgumentException("Missing field x-stargate-role for JWT");
        }
        if (!(stargate_claims.get(ROLE_FIELD) instanceof String)) {
            throw new IllegalArgumentException("Field x-stargate-role must be of type String");
        }
        return (String)stargate_claims.get(ROLE_FIELD);
    }
}

