package io.stargate.auth.entity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuthorizedResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAuthorizedResource.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAuthorizedResource.of()}.
 */
@Generated(from = "AuthorizedResource", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAuthorizedResource implements AuthorizedResource {
  private final ResourceKind kind;
  private final EntitySelector keyspace;
  private final EntitySelector element;

  private ImmutableAuthorizedResource(ResourceKind kind) {
    this.kind = Objects.requireNonNull(kind, "kind");
    this.keyspace = initShim.keyspace();
    this.element = initShim.element();
    this.initShim = null;
  }

  private ImmutableAuthorizedResource(ImmutableAuthorizedResource.Builder builder) {
    this.kind = builder.kind;
    if (builder.keyspace != null) {
      initShim.keyspace(builder.keyspace);
    }
    if (builder.element != null) {
      initShim.element(builder.element);
    }
    this.keyspace = initShim.keyspace();
    this.element = initShim.element();
    this.initShim = null;
  }

  private ImmutableAuthorizedResource(
      ResourceKind kind,
      EntitySelector keyspace,
      EntitySelector element) {
    this.kind = kind;
    this.keyspace = keyspace;
    this.element = element;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AuthorizedResource", generator = "Immutables")
  private final class InitShim {
    private byte keyspaceBuildStage = STAGE_UNINITIALIZED;
    private EntitySelector keyspace;

    EntitySelector keyspace() {
      if (keyspaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keyspaceBuildStage == STAGE_UNINITIALIZED) {
        keyspaceBuildStage = STAGE_INITIALIZING;
        this.keyspace = Objects.requireNonNull(keyspaceInitialize(), "keyspace");
        keyspaceBuildStage = STAGE_INITIALIZED;
      }
      return this.keyspace;
    }

    void keyspace(EntitySelector keyspace) {
      this.keyspace = keyspace;
      keyspaceBuildStage = STAGE_INITIALIZED;
    }

    private byte elementBuildStage = STAGE_UNINITIALIZED;
    private EntitySelector element;

    EntitySelector element() {
      if (elementBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (elementBuildStage == STAGE_UNINITIALIZED) {
        elementBuildStage = STAGE_INITIALIZING;
        this.element = Objects.requireNonNull(elementInitialize(), "element");
        elementBuildStage = STAGE_INITIALIZED;
      }
      return this.element;
    }

    void element(EntitySelector element) {
      this.element = element;
      elementBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (keyspaceBuildStage == STAGE_INITIALIZING) attributes.add("keyspace");
      if (elementBuildStage == STAGE_INITIALIZING) attributes.add("element");
      return "Cannot build AuthorizedResource, attribute initializers form cycle " + attributes;
    }
  }

  private EntitySelector keyspaceInitialize() {
    return AuthorizedResource.super.keyspace();
  }

  private EntitySelector elementInitialize() {
    return AuthorizedResource.super.element();
  }

  /**
   *Identifies the resource kind. 
   */
  @Override
  public ResourceKind kind() {
    return kind;
  }

  /**
   * Identifies the keyspace of the resource.
   * <p>If the keyspace selector is a wildcard, the {@link #element()} selector should also be a
   * wildcard.
   */
  @Override
  public EntitySelector keyspace() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keyspace()
        : this.keyspace;
  }

  /**
   *Identifies the name of the resource. 
   */
  @Override
  public EntitySelector element() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.element()
        : this.element;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizedResource#kind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizedResource withKind(ResourceKind value) {
    if (this.kind == value) return this;
    ResourceKind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableAuthorizedResource(newValue, this.keyspace, this.element);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizedResource#keyspace() keyspace} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizedResource withKeyspace(EntitySelector value) {
    if (this.keyspace == value) return this;
    EntitySelector newValue = Objects.requireNonNull(value, "keyspace");
    return new ImmutableAuthorizedResource(this.kind, newValue, this.element);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthorizedResource#element() element} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for element
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthorizedResource withElement(EntitySelector value) {
    if (this.element == value) return this;
    EntitySelector newValue = Objects.requireNonNull(value, "element");
    return new ImmutableAuthorizedResource(this.kind, this.keyspace, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuthorizedResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuthorizedResource
        && equalTo((ImmutableAuthorizedResource) another);
  }

  private boolean equalTo(ImmutableAuthorizedResource another) {
    return kind.equals(another.kind)
        && keyspace.equals(another.keyspace)
        && element.equals(another.element);
  }

  /**
   * Computes a hash code from attributes: {@code kind}, {@code keyspace}, {@code element}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + kind.hashCode();
    h += (h << 5) + keyspace.hashCode();
    h += (h << 5) + element.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AuthorizedResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthorizedResource{"
        + "kind=" + kind
        + ", keyspace=" + keyspace
        + ", element=" + element
        + "}";
  }

  /**
   * Construct a new immutable {@code AuthorizedResource} instance.
   * @param kind The value for the {@code kind} attribute
   * @return An immutable AuthorizedResource instance
   */
  public static ImmutableAuthorizedResource of(ResourceKind kind) {
    return new ImmutableAuthorizedResource(kind);
  }

  /**
   * Creates an immutable copy of a {@link AuthorizedResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthorizedResource instance
   */
  public static ImmutableAuthorizedResource copyOf(AuthorizedResource instance) {
    if (instance instanceof ImmutableAuthorizedResource) {
      return (ImmutableAuthorizedResource) instance;
    }
    return ImmutableAuthorizedResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAuthorizedResource ImmutableAuthorizedResource}.
   * <pre>
   * ImmutableAuthorizedResource.builder()
   *    .kind(io.stargate.auth.entity.ResourceKind) // required {@link AuthorizedResource#kind() kind}
   *    .keyspace(io.stargate.auth.entity.EntitySelector) // optional {@link AuthorizedResource#keyspace() keyspace}
   *    .element(io.stargate.auth.entity.EntitySelector) // optional {@link AuthorizedResource#element() element}
   *    .build();
   * </pre>
   * @return A new ImmutableAuthorizedResource builder
   */
  public static ImmutableAuthorizedResource.Builder builder() {
    return new ImmutableAuthorizedResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAuthorizedResource ImmutableAuthorizedResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuthorizedResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KIND = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ResourceKind kind;
    private @Nullable EntitySelector keyspace;
    private @Nullable EntitySelector element;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthorizedResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthorizedResource instance) {
      Objects.requireNonNull(instance, "instance");
      kind(instance.kind());
      keyspace(instance.keyspace());
      element(instance.element());
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizedResource#kind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder kind(ResourceKind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizedResource#keyspace() keyspace} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AuthorizedResource#keyspace() keyspace}.</em>
     * @param keyspace The value for keyspace 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keyspace(EntitySelector keyspace) {
      this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
      return this;
    }

    /**
     * Initializes the value for the {@link AuthorizedResource#element() element} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AuthorizedResource#element() element}.</em>
     * @param element The value for element 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder element(EntitySelector element) {
      this.element = Objects.requireNonNull(element, "element");
      return this;
    }

    /**
     * Builds a new {@link ImmutableAuthorizedResource ImmutableAuthorizedResource}.
     * @return An immutable instance of AuthorizedResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAuthorizedResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAuthorizedResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build AuthorizedResource, some of required attributes are not set " + attributes;
    }
  }
}
