package io.stargate.auth.entity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AccessPermission}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAccessPermission.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAccessPermission.of()}.
 */
@Generated(from = "AccessPermission", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAccessPermission implements AccessPermission {
  private final String name;

  private ImmutableAccessPermission(String name) {
    this.name = Objects.requireNonNull(name, "name");
  }

  private ImmutableAccessPermission(ImmutableAccessPermission original, String name) {
    this.name = name;
  }

  /**
   *The name of the permission relative to its {@link PermissionKind}. 
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessPermission#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessPermission withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableAccessPermission(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAccessPermission} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAccessPermission
        && equalTo((ImmutableAccessPermission) another);
  }

  private boolean equalTo(ImmutableAccessPermission another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AccessPermission} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AccessPermission{"
        + "name=" + name
        + "}";
  }

  /**
   * Construct a new immutable {@code AccessPermission} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable AccessPermission instance
   */
  public static ImmutableAccessPermission of(String name) {
    return new ImmutableAccessPermission(name);
  }

  /**
   * Creates an immutable copy of a {@link AccessPermission} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AccessPermission instance
   */
  public static ImmutableAccessPermission copyOf(AccessPermission instance) {
    if (instance instanceof ImmutableAccessPermission) {
      return (ImmutableAccessPermission) instance;
    }
    return ImmutableAccessPermission.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAccessPermission ImmutableAccessPermission}.
   * <pre>
   * ImmutableAccessPermission.builder()
   *    .name(String) // required {@link AccessPermission#name() name}
   *    .build();
   * </pre>
   * @return A new ImmutableAccessPermission builder
   */
  public static ImmutableAccessPermission.Builder builder() {
    return new ImmutableAccessPermission.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAccessPermission ImmutableAccessPermission}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AccessPermission", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AccessPermission} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AccessPermission instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      return this;
    }

    /**
     * Initializes the value for the {@link AccessPermission#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAccessPermission ImmutableAccessPermission}.
     * @return An immutable instance of AccessPermission
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAccessPermission build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAccessPermission(null, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build AccessPermission, some of required attributes are not set " + attributes;
    }
  }
}
