/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import io.stargate.auth.ImmutableAuthenticationSubject;
import io.stargate.db.AuthenticatedUser;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface AuthenticationSubject {
    @Nullable
    public String token();

    public String roleName();

    public boolean isFromExternalAuth();

    public Map<String, String> customProperties();

    default public AuthenticatedUser asUser() {
        return AuthenticatedUser.of((String)this.roleName(), (String)this.token(), (boolean)this.isFromExternalAuth(), this.customProperties());
    }

    public static AuthenticationSubject of(String token, String roleName, boolean fromExternalAuth, Map<String, String> properties) {
        return ImmutableAuthenticationSubject.builder().token(token).roleName(roleName).isFromExternalAuth(fromExternalAuth).customProperties(properties).build();
    }

    public static AuthenticationSubject of(String token, String roleName, boolean fromExternalAuth) {
        return ImmutableAuthenticationSubject.builder().token(token).roleName(roleName).isFromExternalAuth(fromExternalAuth).customProperties(Collections.emptyMap()).build();
    }

    public static AuthenticationSubject of(String token, String roleName) {
        return ImmutableAuthenticationSubject.builder().token(token).roleName(roleName).isFromExternalAuth(false).customProperties(Collections.emptyMap()).build();
    }

    public static AuthenticationSubject of(AuthenticatedUser user) {
        return ImmutableAuthenticationSubject.builder().token(user.token()).roleName(user.name()).isFromExternalAuth(user.isFromExternalAuth()).customProperties(user.customProperties()).build();
    }
}

