/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.Credentials;
import io.stargate.db.AuthenticatedUser;
import io.stargate.db.Authenticator;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.cassandra.stargate.exceptions.AuthenticationException;

public abstract class PlainTextTokenSaslNegotiator
implements Authenticator.SaslNegotiator {
    static final byte NUL = 0;
    protected final AuthenticationService authentication;
    private final Authenticator.SaslNegotiator wrapped;
    protected AuthenticationSubject authenticationSubject;
    protected final String tokenUsername;
    protected final int tokenMaxLength;

    public PlainTextTokenSaslNegotiator(AuthenticationService authentication, Authenticator.SaslNegotiator wrapped, String tokenUsername, int tokenMaxLength) {
        this.authentication = authentication;
        this.wrapped = wrapped;
        this.tokenUsername = tokenUsername;
        this.tokenMaxLength = tokenMaxLength;
    }

    public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
        if (this.attemptTokenAuthentication(clientResponse)) {
            return null;
        }
        return this.wrapped.evaluateResponse(clientResponse);
    }

    public boolean isComplete() {
        return this.authenticationSubject != null || this.wrapped.isComplete();
    }

    public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
        if (this.authenticationSubject != null) {
            return AuthenticatedUser.of((String)this.authenticationSubject.roleName(), (String)this.authenticationSubject.token(), (boolean)this.authenticationSubject.isFromExternalAuth(), this.authenticationSubject.customProperties());
        }
        return this.wrapped.getAuthenticatedUser();
    }

    public abstract boolean attemptTokenAuthentication(byte[] var1);

    public static Credentials decodeCredentials(byte[] bytes) throws AuthenticationException {
        byte[] user = null;
        byte[] pass = null;
        int end = bytes.length;
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] != 0) continue;
            if (pass == null) {
                pass = Arrays.copyOfRange(bytes, i + 1, end);
            } else if (user == null) {
                user = Arrays.copyOfRange(bytes, i + 1, end);
            } else {
                throw new AuthenticationException("Credential format error: username or password is empty or contains NUL(\\0) character");
            }
            end = i;
        }
        if (pass == null || pass.length == 0) {
            throw new AuthenticationException("Password must not be null");
        }
        if (user == null || user.length == 0) {
            throw new AuthenticationException("Authentication ID must not be null");
        }
        String passwd = new String(pass, StandardCharsets.UTF_8);
        return new Credentials(new String(user, StandardCharsets.UTF_8), passwd.toCharArray());
    }
}

