package io.stargate.auth.entity;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Actor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableActor.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableActor.of()}.
 */
@Generated(from = "Actor", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableActor implements Actor {
  private final String roleName;

  private ImmutableActor(String roleName) {
    this.roleName = Objects.requireNonNull(roleName, "roleName");
  }

  private ImmutableActor(ImmutableActor original, String roleName) {
    this.roleName = roleName;
  }

  /**
   * @return The value of the {@code roleName} attribute
   */
  @Override
  public String roleName() {
    return roleName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Actor#roleName() roleName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for roleName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActor withRoleName(String value) {
    String newValue = Objects.requireNonNull(value, "roleName");
    if (this.roleName.equals(newValue)) return this;
    return new ImmutableActor(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableActor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableActor
        && equalTo((ImmutableActor) another);
  }

  private boolean equalTo(ImmutableActor another) {
    return roleName.equals(another.roleName);
  }

  /**
   * Computes a hash code from attributes: {@code roleName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + roleName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Actor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Actor{"
        + "roleName=" + roleName
        + "}";
  }

  /**
   * Construct a new immutable {@code Actor} instance.
   * @param roleName The value for the {@code roleName} attribute
   * @return An immutable Actor instance
   */
  public static ImmutableActor of(String roleName) {
    return new ImmutableActor(roleName);
  }

  /**
   * Creates an immutable copy of a {@link Actor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Actor instance
   */
  public static ImmutableActor copyOf(Actor instance) {
    if (instance instanceof ImmutableActor) {
      return (ImmutableActor) instance;
    }
    return ImmutableActor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableActor ImmutableActor}.
   * <pre>
   * ImmutableActor.builder()
   *    .roleName(String) // required {@link Actor#roleName() roleName}
   *    .build();
   * </pre>
   * @return A new ImmutableActor builder
   */
  public static ImmutableActor.Builder builder() {
    return new ImmutableActor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableActor ImmutableActor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Actor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ROLE_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String roleName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Actor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Actor instance) {
      Objects.requireNonNull(instance, "instance");
      roleName(instance.roleName());
      return this;
    }

    /**
     * Initializes the value for the {@link Actor#roleName() roleName} attribute.
     * @param roleName The value for roleName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roleName(String roleName) {
      this.roleName = Objects.requireNonNull(roleName, "roleName");
      initBits &= ~INIT_BIT_ROLE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableActor ImmutableActor}.
     * @return An immutable instance of Actor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableActor build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableActor(null, roleName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROLE_NAME) != 0) attributes.add("roleName");
      return "Cannot build Actor, some of required attributes are not set " + attributes;
    }
  }
}
