package io.stargate.auth;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuthenticationSubject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAuthenticationSubject.builder()}.
 */
@Generated(from = "AuthenticationSubject", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAuthenticationSubject implements AuthenticationSubject {
  private final @Nullable String token;
  private final String roleName;
  private final boolean isFromExternalAuth;
  private final Map<String, String> customProperties;

  private ImmutableAuthenticationSubject(
      @Nullable String token,
      String roleName,
      boolean isFromExternalAuth,
      Map<String, String> customProperties) {
    this.token = token;
    this.roleName = roleName;
    this.isFromExternalAuth = isFromExternalAuth;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public @Nullable String token() {
    return token;
  }

  /**
   * @return The value of the {@code roleName} attribute
   */
  @Override
  public String roleName() {
    return roleName;
  }

  /**
   * @return The value of the {@code isFromExternalAuth} attribute
   */
  @Override
  public boolean isFromExternalAuth() {
    return isFromExternalAuth;
  }

  /**
   * @return The value of the {@code customProperties} attribute
   */
  @Override
  public Map<String, String> customProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticationSubject#token() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticationSubject withToken(@Nullable String value) {
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableAuthenticationSubject(value, this.roleName, this.isFromExternalAuth, this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticationSubject#roleName() roleName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for roleName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticationSubject withRoleName(String value) {
    String newValue = Objects.requireNonNull(value, "roleName");
    if (this.roleName.equals(newValue)) return this;
    return new ImmutableAuthenticationSubject(this.token, newValue, this.isFromExternalAuth, this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthenticationSubject#isFromExternalAuth() isFromExternalAuth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isFromExternalAuth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuthenticationSubject withIsFromExternalAuth(boolean value) {
    if (this.isFromExternalAuth == value) return this;
    return new ImmutableAuthenticationSubject(this.token, this.roleName, value, this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link AuthenticationSubject#customProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAuthenticationSubject withCustomProperties(Map<String, ? extends String> entries) {
    if (this.customProperties == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableAuthenticationSubject(this.token, this.roleName, this.isFromExternalAuth, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuthenticationSubject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuthenticationSubject
        && equalTo((ImmutableAuthenticationSubject) another);
  }

  private boolean equalTo(ImmutableAuthenticationSubject another) {
    return Objects.equals(token, another.token)
        && roleName.equals(another.roleName)
        && isFromExternalAuth == another.isFromExternalAuth
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code roleName}, {@code isFromExternalAuth}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + roleName.hashCode();
    h += (h << 5) + Boolean.hashCode(isFromExternalAuth);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AuthenticationSubject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthenticationSubject{"
        + "token=" + token
        + ", roleName=" + roleName
        + ", isFromExternalAuth=" + isFromExternalAuth
        + ", customProperties=" + customProperties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AuthenticationSubject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthenticationSubject instance
   */
  public static ImmutableAuthenticationSubject copyOf(AuthenticationSubject instance) {
    if (instance instanceof ImmutableAuthenticationSubject) {
      return (ImmutableAuthenticationSubject) instance;
    }
    return ImmutableAuthenticationSubject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAuthenticationSubject ImmutableAuthenticationSubject}.
   * <pre>
   * ImmutableAuthenticationSubject.builder()
   *    .token(String | null) // nullable {@link AuthenticationSubject#token() token}
   *    .roleName(String) // required {@link AuthenticationSubject#roleName() roleName}
   *    .isFromExternalAuth(boolean) // required {@link AuthenticationSubject#isFromExternalAuth() isFromExternalAuth}
   *    .putCustomProperties|putAllCustomProperties(String =&gt; String) // {@link AuthenticationSubject#customProperties() customProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableAuthenticationSubject builder
   */
  public static ImmutableAuthenticationSubject.Builder builder() {
    return new ImmutableAuthenticationSubject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAuthenticationSubject ImmutableAuthenticationSubject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AuthenticationSubject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ROLE_NAME = 0x1L;
    private static final long INIT_BIT_IS_FROM_EXTERNAL_AUTH = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String token;
    private @Nullable String roleName;
    private boolean isFromExternalAuth;
    private Map<String, String> customProperties = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthenticationSubject} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AuthenticationSubject instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String tokenValue = instance.token();
      if (tokenValue != null) {
        token(tokenValue);
      }
      roleName(instance.roleName());
      isFromExternalAuth(instance.isFromExternalAuth());
      putAllCustomProperties(instance.customProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticationSubject#token() token} attribute.
     * @param token The value for token (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder token(@Nullable String token) {
      this.token = token;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticationSubject#roleName() roleName} attribute.
     * @param roleName The value for roleName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roleName(String roleName) {
      this.roleName = Objects.requireNonNull(roleName, "roleName");
      initBits &= ~INIT_BIT_ROLE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthenticationSubject#isFromExternalAuth() isFromExternalAuth} attribute.
     * @param isFromExternalAuth The value for isFromExternalAuth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isFromExternalAuth(boolean isFromExternalAuth) {
      this.isFromExternalAuth = isFromExternalAuth;
      initBits &= ~INIT_BIT_IS_FROM_EXTERNAL_AUTH;
      return this;
    }

    /**
     * Put one entry to the {@link AuthenticationSubject#customProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperties(String key, String value) {
      this.customProperties.put(
          Objects.requireNonNull(key, "customProperties key"),
          Objects.requireNonNull(value, "customProperties value"));
      return this;
    }

    /**
     * Put one entry to the {@link AuthenticationSubject#customProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.customProperties.put(
          Objects.requireNonNull(k, "customProperties key"),
          Objects.requireNonNull(v, "customProperties value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AuthenticationSubject#customProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customProperties(Map<String, ? extends String> entries) {
      this.customProperties.clear();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AuthenticationSubject#customProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.customProperties.put(
            Objects.requireNonNull(k, "customProperties key"),
            Objects.requireNonNull(v, "customProperties value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableAuthenticationSubject ImmutableAuthenticationSubject}.
     * @return An immutable instance of AuthenticationSubject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAuthenticationSubject build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAuthenticationSubject(token, roleName, isFromExternalAuth, createUnmodifiableMap(false, false, customProperties));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROLE_NAME) != 0) attributes.add("roleName");
      if ((initBits & INIT_BIT_IS_FROM_EXTERNAL_AUTH) != 0) attributes.add("isFromExternalAuth");
      return "Cannot build AuthenticationSubject, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
