/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.server.controllers;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DO.Config;
import com.alibaba.sreworks.server.services.ConfigService;
import com.alibaba.tesla.common.base.TeslaBaseResult;
import com.alibaba.tesla.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
@Api(tags={"\u63d2\u4ef6-\u96c6\u7fa4"})
public class ConfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Autowired
    ConfigService configService;

    @ApiOperation(value="\u7cfb\u7edf\u8bbe\u7f6e")
    @RequestMapping(value={"systemConfig"}, method={RequestMethod.GET})
    public TeslaBaseResult systemConfig() {
        List<Config> configList = this.configService.getAll();
        return this.buildSucceedResult(configList.stream().collect(Collectors.toMap(Config::getName, Config::getContent)));
    }

    @ApiOperation(value="checkGitConfig")
    @RequestMapping(value={"checkGitConfig"}, method={RequestMethod.POST})
    public TeslaBaseResult checkGitConfig(@RequestBody JSONObject jsonObject) {
        GitlabAPI api;
        String repoDomain = jsonObject.getString("repoDomain");
        String repoGroup = jsonObject.getString("repoGroup");
        String token = jsonObject.getString("token");
        JSONObject result = new JSONObject();
        result.put("result", (Object)"ERROR");
        try {
            api = GitlabAPI.connect((String)repoDomain, (String)token);
        }
        catch (Exception e) {
            result.put("message", (Object)"Gitlab\u670d\u52a1\u68c0\u67e5\u5931\u8d25,\u65e0\u6cd5\u4f7f\u7528\u81ea\u52a8\u521b\u5efa\u4ed3\u5e93\u80fd\u529b");
            return this.buildSucceedResult(result);
        }
        try {
            GitlabGroup group = api.getGroup(repoGroup);
        }
        catch (IOException e) {
            result.put("message", (Object)"\u68c0\u67e5Gitlab Group\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5Gitlab Group\u662f\u5426\u5b58\u5728");
            return this.buildSucceedResult(result);
        }
        result.put("result", (Object)"OK");
        result.put("repoDomain", (Object)repoDomain);
        result.put("repoGroup", (Object)repoDomain);
        result.put("message", (Object)"Gitlab\u670d\u52a1\u68c0\u67e5\u6210\u529f, \u53ef\u4ee5\u4f7f\u7528\u81ea\u52a8\u521b\u5efa\u4ed3\u5e93\u80fd\u529b");
        return this.buildSucceedResult(result);
    }

    @ApiOperation(value="set")
    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    public TeslaBaseResult set(@RequestBody JSONObject jsonObject) {
        for (String name : jsonObject.keySet()) {
            String content = jsonObject.getString(name);
            this.configService.set(name, content, this.getUserEmployeeId());
        }
        JSONObject result = new JSONObject();
        result.put("result", (Object)"OK");
        result.put("data", (Object)jsonObject);
        return this.buildSucceedResult(result);
    }

    @ApiOperation(value="get")
    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    public TeslaBaseResult get(String name) {
        return this.buildSucceedResult(this.configService.get(name));
    }

    @ApiOperation(value="setObject")
    @RequestMapping(value={"setObject"}, method={RequestMethod.POST})
    public TeslaBaseResult setObject(String name, @RequestBody JSONObject content) {
        this.configService.set(name, JSONObject.toJSONString((Object)content), this.getUserEmployeeId());
        return this.buildSucceedResult("OK");
    }

    @ApiOperation(value="getObject")
    @RequestMapping(value={"getObject"}, method={RequestMethod.GET})
    public TeslaBaseResult getObject(String name) {
        return this.buildSucceedResult(JSONObject.parse((String)this.configService.get(name)));
    }
}

