/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.common.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    public static void zipDirectory(String zipPath, String directory) throws ZipException {
        new ZipFile(zipPath).addFolder(new File(directory));
    }

    public static void zipFiles(String zipPath, List<File> files) throws ZipException {
        ZipParameters parameters = new ZipParameters();
        parameters.setIncludeRootFolder(false);
        new ZipFile(zipPath).addFiles(files, parameters);
    }

    public static void unzip(String zipPath, String destDir) throws ZipException {
        new ZipFile(zipPath).extractAll(destDir);
    }

    public static String getZipSpecifiedFile(String zipPath, String filePath) throws IOException {
        File tmpMetaYaml = File.createTempFile("meta", ".yaml");
        String parentDir = tmpMetaYaml.toPath().getParent().toString();
        String absPath = tmpMetaYaml.toPath().toString();
        new ZipFile(zipPath).extractFile(filePath, parentDir, tmpMetaYaml.getName());
        String content = Files.asCharSource((File)tmpMetaYaml, (Charset)StandardCharsets.UTF_8).read();
        if (!tmpMetaYaml.delete()) {
            log.error("cannot delete temp file {} when get zip specified file", (Object)absPath);
        }
        return content;
    }
}

