/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.common.util;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Namespaces;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sUtil {
    private static final Logger log = LoggerFactory.getLogger(K8sUtil.class);
    public static ApiClient client;

    public static List<V1Service> listServiceForAllNamespaces(String labelSelector) throws ApiException {
        CoreV1Api api = new CoreV1Api();
        V1ServiceList serviceList = api.listServiceForAllNamespaces(null, null, null, labelSelector, null, null, null, null, null, null);
        return serviceList.getItems();
    }

    public static List<V1Service> listService(String labelSelector) throws ApiException, IOException {
        String podNamespace = Namespaces.getPodNamespace();
        CoreV1Api api = new CoreV1Api();
        V1ServiceList serviceList = api.listNamespacedService(podNamespace, null, null, null, null, labelSelector, null, null, null, null, null);
        return serviceList.getItems();
    }

    public static List<V1Service> listServiceByFieldSelector(String fieldSelector) throws ApiException, IOException {
        String podNamespace = Namespaces.getPodNamespace();
        CoreV1Api api = new CoreV1Api();
        V1ServiceList serviceList = api.listNamespacedService(podNamespace, null, null, null, fieldSelector, null, null, null, null, null, null);
        return serviceList.getItems();
    }

    public static List<String> getServiceEndpoint(V1Service service) throws IOException, ApiException {
        String name = service.getMetadata().getName();
        String namespace = service.getMetadata().getNamespace();
        return service.getSpec().getPorts().stream().map(port -> String.format("http://%s.%s:%s", name, namespace, port.getPort())).collect(Collectors.toList());
    }

    public static String getServiceLabel(V1Service service, String key) throws IOException, ApiException {
        return (String)service.getMetadata().getLabels().get(key);
    }

    public static File getKubeConfigFile(String kubeconfig) throws IOException {
        File file = File.createTempFile("kubeconfig", "");
        file.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(kubeconfig);
        out.close();
        return file;
    }

    public static ApiClient client(String kubeconfig) throws IOException {
        return Config.fromConfig((String)K8sUtil.getKubeConfigFile(kubeconfig).getAbsolutePath());
    }

    static {
        try {
            client = new File("/var/run/secrets/kubernetes.io/serviceaccount/token").exists() ? Config.fromCluster() : Config.defaultClient();
            Configuration.setDefaultApiClient((ApiClient)client);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }
}

