/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import io.squashql.store.TypedField;
import io.squashql.util.Types;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public final class SparkUtil {
    private SparkUtil() {
    }

    public static Class<?> datatypeToClass(DataType type) {
        Class klass;
        if (type.equals(DataTypes.StringType)) {
            klass = String.class;
        } else if (type.equals(DataTypes.DoubleType)) {
            klass = Double.TYPE;
        } else if (type.equals(DataTypes.FloatType)) {
            klass = Float.TYPE;
        } else if (type.equals(DataTypes.IntegerType)) {
            klass = Integer.TYPE;
        } else if (type.equals(DataTypes.LongType)) {
            klass = Long.TYPE;
        } else if (type.equals(DataTypes.ByteType)) {
            klass = Byte.TYPE;
        } else if (type.equals(DataTypes.BooleanType)) {
            klass = Boolean.TYPE;
        } else if (type.equals(DataTypes.DateType)) {
            klass = LocalDate.class;
        } else {
            if (type.sql().contains("DECIMAL")) {
                return BigDecimal.class;
            }
            throw new IllegalArgumentException("Unsupported field type " + type);
        }
        return klass;
    }

    public static DataType classToDatatype(Class<?> clazz) {
        DataType type;
        if (clazz.equals(String.class)) {
            type = DataTypes.StringType;
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            type = DataTypes.DoubleType;
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            type = DataTypes.FloatType;
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            type = DataTypes.IntegerType;
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            type = DataTypes.LongType;
        } else if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            type = DataTypes.ByteType;
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            type = DataTypes.BooleanType;
        } else if (clazz.equals(LocalDate.class)) {
            type = DataTypes.DateType;
        } else {
            throw new IllegalArgumentException("Unsupported field type " + clazz);
        }
        return type;
    }

    public static Object getTypeValue(Object o) {
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            return Types.castToDouble((BigDecimal)bd);
        }
        return o;
    }

    public static StructType createSchema(List<TypedField> fields) {
        StructType schema = new StructType();
        for (TypedField field : fields) {
            schema = schema.add(field.name(), SparkUtil.classToDatatype(field.type()));
        }
        return schema;
    }
}

