/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import io.squashql.SparkDatastore;
import io.squashql.SparkUtil;
import io.squashql.transaction.DataLoader;
import io.squashql.type.TableTypedField;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.types.StructType;

public class SparkDataLoader
implements DataLoader {
    protected final SparkSession spark;

    public SparkDataLoader(SparkSession spark) {
        this.spark = spark;
    }

    public void createTemporaryTable(String table, List<TableTypedField> fields) {
        SparkDataLoader.createTemporaryTable(this.spark, table, fields);
    }

    public static void createTemporaryTable(SparkSession spark, String table, List<TableTypedField> fields) {
        StructType schema = SparkUtil.createSchema(fields);
        spark.conf().set("spark.sql.caseSensitive", String.valueOf(true));
        spark.createDataFrame(Collections.emptyList(), schema).createOrReplaceTempView(table);
    }

    public void load(String table, List<Object[]> tuples) {
        Dataset dataFrame = this.spark.createDataFrame(tuples.stream().map(RowFactory::create).toList(), SparkUtil.createSchema(SparkDatastore.getFields(this.spark, table)));
        SparkDataLoader.appendDataset(this.spark, table, (Dataset<Row>)dataFrame);
    }

    static void appendDataset(SparkSession spark, String store, Dataset<Row> dataset) {
        String viewName = "tmp_" + store;
        spark.sql("ALTER VIEW " + store + " RENAME TO " + viewName);
        Dataset table = spark.table(viewName);
        Dataset union = table.union(dataset);
        union.createOrReplaceTempView(store);
        spark.catalog().dropTempView(viewName);
    }

    public void loadCsv(String store, String path, String delimiter, boolean header) {
        Dataset dataFrame = this.spark.read().option("delimiter", delimiter).option("header", true).csv(path);
        Table table = null;
        try {
            table = this.spark.catalog().getTable(store);
        }
        catch (AnalysisException analysisException) {
            // empty catch block
        }
        if (table == null) {
            this.spark.conf().set("spark.sql.caseSensitive", String.valueOf(true));
            dataFrame.createOrReplaceTempView(store);
        } else {
            SparkDataLoader.appendDataset(this.spark, store, (Dataset<Row>)dataFrame);
        }
    }
}

