/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import io.squashql.SparkDatastore;
import io.squashql.SparkUtil;
import io.squashql.store.Field;
import io.squashql.transaction.TransactionManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructType;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl;

public class SparkTransactionManager
implements TransactionManager {
    protected final SparkSession spark;

    public SparkTransactionManager(SparkSession spark) {
        this.spark = spark;
    }

    public void createTemporaryTable(String table, List<Field> fields) {
        SparkTransactionManager.createTemporaryTable(this.spark, table, fields, true);
    }

    public void createTemporaryTable(String table, List<Field> fields, boolean cjMode) {
        SparkTransactionManager.createTemporaryTable(this.spark, table, fields, cjMode);
    }

    public static void createTemporaryTable(SparkSession spark, String table, List<Field> fields, boolean cjMode) {
        ImmutableList all = ImmutableListFactoryImpl.INSTANCE.ofAll(fields);
        if (cjMode) {
            all = all.newWith((Object)new Field(table, "scenario", String.class));
        }
        StructType schema = SparkUtil.createSchema(all.castToList());
        spark.conf().set("spark.sql.caseSensitive", String.valueOf(true));
        spark.createDataFrame(Collections.emptyList(), schema).createOrReplaceTempView(table);
    }

    public void load(String scenario, String store, List<Object[]> tuples) {
        if (!scenario.equals("base")) {
            this.ensureScenarioColumnIsPresent(store);
        }
        boolean addScenario = this.scenarioColumnIsPresent(store);
        List<Row> rows = tuples.stream().map(tuple -> {
            Object[] copy = tuple;
            if (addScenario) {
                copy = Arrays.copyOf(tuple, ((Object[])tuple).length + 1);
                copy[copy.length - 1] = scenario;
            }
            return RowFactory.create((Object[])copy);
        }).toList();
        Dataset dataFrame = this.spark.createDataFrame(rows, SparkUtil.createSchema(SparkDatastore.getFields(this.spark, store)));
        SparkTransactionManager.appendDataset(this.spark, store, (Dataset<Row>)dataFrame);
    }

    static void appendDataset(SparkSession spark, String store, Dataset<Row> dataset) {
        String viewName = "tmp_" + store;
        spark.sql("ALTER VIEW " + store + " RENAME TO " + viewName);
        Dataset table = spark.table(viewName);
        Dataset union = table.union(dataset);
        union.createOrReplaceTempView(store);
        spark.catalog().dropTempView(viewName);
    }

    private void ensureScenarioColumnIsPresent(String store) {
        if (!this.scenarioColumnIsPresent(store)) {
            throw new RuntimeException(String.format("%s field not found", "scenario"));
        }
    }

    private boolean scenarioColumnIsPresent(String store) {
        List<Field> fields = SparkDatastore.getFields(this.spark, store);
        return fields.stream().anyMatch(f -> f.name().equals("scenario"));
    }

    public void loadCsv(String scenario, String store, String path, String delimiter, boolean header) {
        Dataset dataFrame = this.spark.read().option("delimiter", delimiter).option("header", true).csv(path).withColumn("scenario", functions.lit((Object)scenario));
        Table table = null;
        try {
            table = this.spark.catalog().getTable(store);
        }
        catch (AnalysisException analysisException) {
            // empty catch block
        }
        if (table == null) {
            this.spark.conf().set("spark.sql.caseSensitive", String.valueOf(true));
            dataFrame.createOrReplaceTempView(store);
        } else {
            SparkTransactionManager.appendDataset(this.spark, store, (Dataset<Row>)dataFrame);
        }
    }
}

