/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import io.squashql.store.Field;
import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public final class SparkUtil {
    private SparkUtil() {
    }

    public static Class<?> datatypeToClass(DataType type) {
        Class klass;
        if (type.equals(DataTypes.StringType)) {
            klass = String.class;
        } else if (type.equals(DataTypes.DoubleType)) {
            klass = Double.TYPE;
        } else if (type.equals(DataTypes.FloatType)) {
            klass = Float.TYPE;
        } else if (type.equals(DataTypes.IntegerType)) {
            klass = Integer.TYPE;
        } else if (type.equals(DataTypes.LongType)) {
            klass = Long.TYPE;
        } else if (type.equals(DataTypes.ByteType)) {
            klass = Byte.TYPE;
        } else if (type.equals(DataTypes.BooleanType)) {
            klass = Boolean.TYPE;
        } else {
            throw new IllegalArgumentException("Unsupported field type " + type);
        }
        return klass;
    }

    public static DataType classToDatatype(Class<?> clazz) {
        DataType type;
        if (clazz.equals(String.class)) {
            type = DataTypes.StringType;
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            type = DataTypes.DoubleType;
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            type = DataTypes.FloatType;
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            type = DataTypes.IntegerType;
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            type = DataTypes.LongType;
        } else if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            type = DataTypes.ByteType;
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            type = DataTypes.BooleanType;
        } else {
            throw new IllegalArgumentException("Unsupported field type " + clazz);
        }
        return type;
    }

    public static StructType createSchema(List<Field> fields) {
        StructType schema = new StructType();
        for (Field field : fields) {
            schema = schema.add(field.name(), SparkUtil.classToDatatype(field.type()));
        }
        return schema;
    }
}

