/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.js;

import io.squashql.jackson.JacksonUtil;
import io.squashql.query.AggregatedMeasure;
import io.squashql.query.AliasedField;
import io.squashql.query.BasicMeasure;
import io.squashql.query.BinaryOperationMeasure;
import io.squashql.query.BinaryOperator;
import io.squashql.query.ColumnSet;
import io.squashql.query.ColumnSetKey;
import io.squashql.query.ComparisonMeasureReferencePosition;
import io.squashql.query.ComparisonMethod;
import io.squashql.query.ConstantField;
import io.squashql.query.CountMeasure;
import io.squashql.query.ExpressionMeasure;
import io.squashql.query.Field;
import io.squashql.query.Functions;
import io.squashql.query.Measure;
import io.squashql.query.TableField;
import io.squashql.query.TotalCountMeasure;
import io.squashql.query.builder.Query;
import io.squashql.query.dto.BucketColumnSetDto;
import io.squashql.query.dto.ConditionDto;
import io.squashql.query.dto.ConditionType;
import io.squashql.query.dto.CriteriaDto;
import io.squashql.query.dto.JoinType;
import io.squashql.query.dto.OrderKeywordDto;
import io.squashql.query.dto.Period;
import io.squashql.query.dto.PivotTableQueryDto;
import io.squashql.query.dto.PivotTableQueryMergeDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryJoinDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.SimpleOrderDto;
import io.squashql.query.dto.TableDto;
import io.squashql.query.dto.VirtualTableDto;
import io.squashql.query.parameter.Parameter;
import io.squashql.query.parameter.QueryCacheParameter;
import io.squashql.util.TestUtil;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJavascriptLibrary {
    @Test
    void testReadJsonBuildFromQueryDto() {
        TableDto table = new TableDto("myTable");
        TableDto refTable = new TableDto("refTable");
        table.join(refTable, JoinType.INNER, Functions.criterion((String)"fromField", (String)"toField", (ConditionType)ConditionType.EQ));
        table.join(new TableDto("a"), JoinType.LEFT, Functions.criterion((String)"a.a_id", (String)"myTable.id", (ConditionType)ConditionType.EQ));
        Field a = TableField.tableField((String)"a");
        Field b = TableField.tableField((String)"b").as("b_alias");
        QueryDto q = new QueryDto().table(table).withColumn(a).withColumn(b);
        AggregatedMeasure price = new AggregatedMeasure("price.sum", "price", "sum");
        q.withMeasure((Measure)price);
        AggregatedMeasure priceFood = new AggregatedMeasure("alias", "price", "sum", Functions.criterion((String)"category", (ConditionDto)Functions.eq((Object)"food")));
        q.withMeasure((Measure)priceFood);
        BinaryOperationMeasure plus = new BinaryOperationMeasure("plusMeasure", BinaryOperator.PLUS, (Measure)price, (Measure)priceFood);
        q.withMeasure((Measure)plus);
        ExpressionMeasure expression = new ExpressionMeasure("myExpression", "sum(price*quantity)");
        q.withMeasure((Measure)expression);
        q.withMeasure((Measure)CountMeasure.INSTANCE);
        q.withMeasure((Measure)TotalCountMeasure.INSTANCE);
        q.withMeasure(Functions.integer((long)123L));
        q.withMeasure(Functions.decimal((double)1.23));
        TableField f1 = new TableField("myTable.f1");
        TableField f2 = new TableField("myTable.f2");
        TableField rate = new TableField("rate");
        ConstantField one = new ConstantField((Object)1);
        q.withMeasure(Functions.avgIf((String)"whatever", (Field)Functions.divide((Field)f1, (Field)Functions.plus((Field)one, (Field)rate)), (CriteriaDto)Functions.criterion((Field)Functions.plus((Field)f1, (Field)f2).as("f1+f2"), (Field)one, (ConditionType)ConditionType.GT)));
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("comp bucket", ComparisonMethod.ABSOLUTE_DIFFERENCE, (Measure)price, Map.of(TableField.tableField((String)"scenario"), "s-1", TableField.tableField((String)"group"), "g"), ColumnSetKey.BUCKET));
        Period.Month month = new Period.Month(TableField.tableField((String)"Month"), TableField.tableField((String)"Year"));
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("growth", ComparisonMethod.DIVIDE, (Measure)price, Map.of(TableField.tableField((String)"Year"), "y-1", TableField.tableField((String)"Month"), "m"), (Period)month));
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("parent", ComparisonMethod.DIVIDE, (Measure)price, List.of(TableField.tableField((String)"Year"), TableField.tableField((String)"Month"))));
        ConditionDto queryCondition = Functions.or((ConditionDto)Functions.and((ConditionDto)Functions.eq((Object)"a"), (ConditionDto)Functions.eq((Object)"b"), (ConditionDto[])new ConditionDto[0]), (ConditionDto)Functions.lt((Object)5), (ConditionDto[])new ConditionDto[]{Functions.like((String)"a%")});
        q.withCondition(TableField.tableField((String)"f1"), queryCondition);
        q.withCondition(TableField.tableField((String)"f2"), Functions.gt((Object)659));
        q.withCondition(TableField.tableField((String)"f3"), Functions.in((Object[])new Object[]{0, 1, 2}));
        q.withCondition(TableField.tableField((String)"f4"), Functions.isNull());
        q.withCondition(TableField.tableField((String)"f5"), Functions.isNotNull());
        q.withHavingCriteria(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((BasicMeasure)price, (ConditionDto)Functions.ge((Object)10)), Functions.criterion((BasicMeasure)expression, (ConditionDto)Functions.lt((Object)100))}));
        q.orderBy(a, OrderKeywordDto.ASC);
        q.orderBy(b, List.of("1", "l", "p"));
        BucketColumnSetDto columnSet = new BucketColumnSetDto("group", TableField.tableField((String)"scenario")).withNewBucket("a", List.of("a1", "a2")).withNewBucket("b", List.of("b1", "b2"));
        q.withColumnSet(ColumnSetKey.BUCKET, (ColumnSet)columnSet);
        QueryDto subQuery = new QueryDto().table(table).withColumn(TableField.tableField((String)"aa")).withColumn((Field)new AliasedField("bb")).withMeasure(Functions.sum((String)"sum_aa", (String)"f"));
        q.table(subQuery);
        String name = "build-from-querydto.json";
        QueryDto qjs = (QueryDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), QueryDto.class);
        Assertions.assertThat((Map)q.columnSets).isEqualTo((Object)qjs.columnSets);
        Assertions.assertThat((List)q.columns).isEqualTo((Object)qjs.columns);
        Assertions.assertThat((List)q.rollupColumns).isEqualTo((Object)qjs.rollupColumns);
        Assertions.assertThat((Map)q.parameters).isEqualTo((Object)qjs.parameters);
        Assertions.assertThat((Map)q.orders).isEqualTo((Object)qjs.orders);
        Assertions.assertThat((List)q.measures).isEqualTo((Object)qjs.measures);
        Assertions.assertThat((Object)q.whereCriteriaDto).isEqualTo((Object)qjs.whereCriteriaDto);
        Assertions.assertThat((Object)q.table).isEqualTo((Object)qjs.table);
        Assertions.assertThat((Object)q.subQuery).isEqualTo((Object)qjs.subQuery);
        Assertions.assertThat((Object)q).isEqualTo((Object)qjs);
    }

    @Test
    void testReadJsonBuildFromQuery() {
        TableDto table = new TableDto("myTable");
        TableDto refTable = new TableDto("refTable");
        VirtualTableDto cte1 = new VirtualTableDto("myCte1", List.of("id", "min", "max", "other"), List.of(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), "x"), List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), "y")));
        VirtualTableDto cte2 = new VirtualTableDto("myCte2", List.of("id", "min", "max", "other"), List.of(List.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(12), "a"), List.of(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(25), "b")));
        BucketColumnSetDto bucketColumnSet = new BucketColumnSetDto("group", TableField.tableField((String)"scenario")).withNewBucket("a", List.of("a1", "a2")).withNewBucket("b", List.of("b1", "b2"));
        Measure measure = Functions.sum((String)"sum", (String)"f1");
        ExpressionMeasure measureExpr = new ExpressionMeasure("sum_expr", "sum(f1)");
        QueryDto q = Query.from((String)table.name).join(refTable.name, JoinType.INNER).on(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((String)"myTable.id", (String)"refTable.id", (ConditionType)ConditionType.EQ), Functions.criterion((String)"myTable.a", (String)"refTable.a", (ConditionType)ConditionType.EQ)})).join(cte1, JoinType.INNER).on(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((String)"myTable.value", (String)"myCte1.min", (ConditionType)ConditionType.GE), Functions.criterion((String)"myTable.value", (String)"myCte1.max", (ConditionType)ConditionType.LT)})).join(cte2, JoinType.INNER).on(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((String)"myTable.value", (String)"myCte2.min", (ConditionType)ConditionType.GE), Functions.criterion((String)"myTable.value", (String)"myCte2.max", (ConditionType)ConditionType.LT)})).where(TableField.tableField((String)"f2"), Functions.gt((Object)659)).where(TableField.tableField((String)"f3"), Functions.eq((Object)123)).select(TableField.tableFields(List.of("a", "b")), List.of(bucketColumnSet), List.of(measure, Functions.avg((String)"sum", (String)"f1"), measureExpr)).rollup(new Field[]{TableField.tableField((String)"a"), TableField.tableField((String)"b")}).having(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((BasicMeasure)((BasicMeasure)measure), (ConditionDto)Functions.gt((Object)0)), Functions.criterion((BasicMeasure)((BasicMeasure)measureExpr), (ConditionDto)Functions.lt((Object)10))})).orderBy(TableField.tableField((String)"f4"), OrderKeywordDto.ASC).limit(10).build();
        q.withParameter("cache", (Parameter)new QueryCacheParameter(QueryCacheParameter.Action.NOT_USE));
        String name = "build-from-query.json";
        QueryDto qjs = (QueryDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), QueryDto.class);
        Assertions.assertThat((Map)q.columnSets).isEqualTo((Object)qjs.columnSets);
        Assertions.assertThat((List)q.columns).isEqualTo((Object)qjs.columns);
        Assertions.assertThat((List)q.rollupColumns).isEqualTo((Object)qjs.rollupColumns);
        Assertions.assertThat((Map)q.parameters).isEqualTo((Object)qjs.parameters);
        Assertions.assertThat((Map)q.orders).isEqualTo((Object)qjs.orders);
        Assertions.assertThat((List)q.measures).isEqualTo((Object)qjs.measures);
        Assertions.assertThat((Object)q.whereCriteriaDto).isEqualTo((Object)qjs.whereCriteriaDto);
        Assertions.assertThat((Object)q.table).isEqualTo((Object)qjs.table);
        Assertions.assertThat((Object)q.subQuery).isEqualTo((Object)qjs.subQuery);
        Assertions.assertThat((int)q.limit).isEqualTo(qjs.limit);
        Assertions.assertThat((List)q.virtualTableDtos).isEqualTo((Object)qjs.virtualTableDtos);
        Assertions.assertThat((Object)q).isEqualTo((Object)qjs);
    }

    @Test
    void testReadJsonBuildFromQueryMerge() {
        TableDto table = new TableDto("myTable");
        QueryDto q1 = Query.from((String)table.name).select(TableField.tableFields(List.of("a", "b")), List.of(Functions.sum((String)"sum", (String)"f1"))).build();
        QueryDto q2 = Query.from((String)table.name).select(TableField.tableFields(List.of("a", "b")), List.of(Functions.avg((String)"sum", (String)"f1"))).build();
        QueryMergeDto query = new QueryMergeDto(q1, q2, JoinType.LEFT);
        String name = "build-from-query-merge.json";
        QueryMergeDto qjs = (QueryMergeDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), QueryMergeDto.class);
        Assertions.assertThat((Object)qjs).isEqualTo((Object)query);
    }

    @Test
    void testReadJsonBuildFromQueryPivot() {
        TableDto table = new TableDto("myTable");
        QueryDto q = Query.from((String)table.name).select(TableField.tableFields(List.of("a", "b")), List.of(Functions.avg((String)"sum", (String)"f1"))).build();
        String name = "build-from-query-pivot.json";
        PivotTableQueryDto qjs = (PivotTableQueryDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), PivotTableQueryDto.class);
        Assertions.assertThat((Object)qjs).isEqualTo((Object)new PivotTableQueryDto(q, TableField.tableFields(List.of("a")), TableField.tableFields(List.of("b"))));
    }

    @Test
    void testReadJsonBuildFromQueryMergePivot() {
        TableDto table = new TableDto("myTable");
        QueryDto q1 = Query.from((String)table.name).select(TableField.tableFields(List.of("a", "b")), List.of(Functions.sum((String)"sum", (String)"f1"))).build();
        QueryDto q2 = Query.from((String)table.name).select(TableField.tableFields(List.of("a", "b")), List.of(Functions.avg((String)"sum", (String)"f1"))).build();
        QueryMergeDto query = new QueryMergeDto(q1, q2, JoinType.LEFT);
        PivotTableQueryMergeDto pivotTableQueryMergeDto = new PivotTableQueryMergeDto(query, TableField.tableFields(List.of("a")), TableField.tableFields(List.of("b")));
        String name = "build-from-query-merge-pivot.json";
        PivotTableQueryMergeDto qjs = (PivotTableQueryMergeDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), PivotTableQueryMergeDto.class);
        Assertions.assertThat((Object)qjs).isEqualTo((Object)pivotTableQueryMergeDto);
    }

    @Test
    void testReadJsonBuildFromQueryJoin() {
        TableField a = new TableField("myTable1", "a");
        TableField b1 = new TableField("myTable1", "b");
        TableField c1 = new TableField("myTable1", "c");
        QueryDto query1 = Query.from((String)"myTable1").select(List.of(a, b1, c1), List.of(Functions.sum((String)"sum", (Field)new TableField("f1")))).build();
        TableField b2 = new TableField("myTable2", "b");
        TableField c2 = new TableField("myTable2", "c");
        QueryDto query2 = Query.from((String)"myTable2").select(List.of(b2, c2), List.of(Functions.avg((String)"sum", (Field)new TableField("f2")))).build();
        QueryJoinDto q = new QueryJoinDto(query1, query2, JoinType.LEFT, Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((Field)b1, (Field)b2, (ConditionType)ConditionType.EQ), Functions.criterion((Field)c1, (Field)c2, (ConditionType)ConditionType.EQ)}), Map.of(a, new SimpleOrderDto(OrderKeywordDto.ASC)), 10);
        String name = "build-from-query-join.json";
        QueryJoinDto qjs = (QueryJoinDto)JacksonUtil.deserialize((String)TestUtil.readAllLines((String)name), QueryJoinDto.class);
        Assertions.assertThat((Object)qjs).isEqualTo((Object)q);
    }
}

