/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.spring.web.rest;

import io.squashql.jackson.JacksonUtil;
import io.squashql.query.BasicUser;
import io.squashql.query.ColumnSetKey;
import io.squashql.query.ComparisonMeasureReferencePosition;
import io.squashql.query.ComparisonMethod;
import io.squashql.query.CountMeasure;
import io.squashql.query.ExpressionMeasure;
import io.squashql.query.Functions;
import io.squashql.query.Measure;
import io.squashql.query.SquashQLUser;
import io.squashql.query.TableField;
import io.squashql.query.builder.Query;
import io.squashql.query.database.DuckDBQueryEngine;
import io.squashql.query.dto.BucketColumnSetDto;
import io.squashql.query.dto.ConditionType;
import io.squashql.query.dto.JoinType;
import io.squashql.query.dto.MetadataItem;
import io.squashql.query.dto.MetadataResultDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.QueryResultDto;
import io.squashql.spring.dataset.DatasetTestConfig;
import io.squashql.spring.web.rest.QueryController;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@SpringBootTest(properties={"spring.main.allow-bean-definition-overriding=true"})
@Import(value={DatasetTestConfig.class})
@AutoConfigureMockMvc
public class QueryControllerTest {
    @Autowired
    MockMvc mvc;
    @Autowired
    QueryController queryController;

    @Test
    void testQuery() throws Exception {
        QueryDto query = Query.from((String)"our_prices").join("our_stores_their_stores", JoinType.INNER).on(Functions.criterion((String)"our_prices.pdv", (String)"our_stores_their_stores.our_store", (ConditionType)ConditionType.EQ)).join("their_prices", JoinType.INNER).on(Functions.criterion((String)"their_prices.competitor_concurrent_pdv", (String)"our_stores_their_stores.their_store", (ConditionType)ConditionType.EQ)).select(TableField.tableFields(List.of("scenario", "ean")), List.of(Functions.sum((String)"capdv", (String)"capdv"), new ExpressionMeasure("capdv_concurrents", "sum(competitor_price * quantity)"), new ExpressionMeasure("indice_prix", "sum(capdv) / sum(competitor_price * quantity)"))).build();
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/query", (Object[])new Object[0]).content(JacksonUtil.serialize((Object)query)).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(result -> {
            String contentAsString = result.getResponse().getContentAsString();
            QueryResultDto queryResult = (QueryResultDto)JacksonUtil.deserialize((String)contentAsString, QueryResultDto.class);
            Assertions.assertThat((List)queryResult.table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("MN & MDD up", "Nutella 250g", Double.valueOf(110000.0), Double.valueOf(102000.0), Double.valueOf(1.0784313725490196)), List.of("MN & MDD up", "ITMella 250g", Double.valueOf(110000.0), Double.valueOf(102000.0), Double.valueOf(1.0784313725490196)), List.of("MN up", "Nutella 250g", Double.valueOf(110000.0), Double.valueOf(102000.0), Double.valueOf(1.0784313725490196)), List.of("MN up", "ITMella 250g", Double.valueOf(100000.0), Double.valueOf(102000.0), Double.valueOf(0.9803921568627451)), List.of("MDD up", "ITMella 250g", Double.valueOf(110000.0), Double.valueOf(102000.0), Double.valueOf(1.0784313725490196)), List.of("MDD up", "Nutella 250g", Double.valueOf(100000.0), Double.valueOf(102000.0), Double.valueOf(0.9803921568627451)), List.of("MN & MDD down", "Nutella 250g", Double.valueOf(90000.0), Double.valueOf(102000.0), Double.valueOf(0.8823529411764706)), List.of("MN & MDD down", "ITMella 250g", Double.valueOf(90000.0), Double.valueOf(102000.0), Double.valueOf(0.8823529411764706)), List.of("base", "ITMella 250g", Double.valueOf(100000.0), Double.valueOf(102000.0), Double.valueOf(0.9803921568627451)), List.of("base", "Nutella 250g", Double.valueOf(100000.0), Double.valueOf(102000.0), Double.valueOf(0.9803921568627451))});
            Assertions.assertThat((List)queryResult.table.columns).containsExactly((Object[])new String[]{"scenario", "ean", "capdv", "capdv_concurrents", "indice_prix"});
            Assertions.assertThat((List)queryResult.metadata).containsExactly((Object[])new MetadataItem[]{new MetadataItem("scenario", "scenario", String.class), new MetadataItem("ean", "ean", String.class), new MetadataItem("capdv", "sum(capdv)", Double.TYPE), new MetadataItem("capdv_concurrents", "sum(competitor_price * quantity)", Double.TYPE), new MetadataItem("indice_prix", "sum(capdv) / sum(competitor_price * quantity)", Double.TYPE)});
            Assertions.assertThat((Object)queryResult.debug.cache).isNotNull();
        });
    }

    @Test
    void testMetadata() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/metadata", (Object[])new Object[0])).andExpect(result -> {
            String contentAsString = result.getResponse().getContentAsString();
            QueryControllerTest.assertMetadataResult((MetadataResultDto)JacksonUtil.OBJECT_MAPPER.readValue(contentAsString, MetadataResultDto.class));
        });
    }

    public static void assertMetadataResult(MetadataResultDto metadataResultDto) {
        Function<String, MetadataResultDto.StoreMetadata> f = storeName -> metadataResultDto.stores.stream().filter(s -> s.name.equals(storeName)).findFirst().get();
        Assertions.assertThat((List)f.apply((String)"our_prices").fields).containsExactlyInAnyOrder((Object[])new MetadataItem[]{new MetadataItem("ean", "ean", String.class), new MetadataItem("pdv", "pdv", String.class), new MetadataItem("price", "price", Double.TYPE), new MetadataItem("quantity", "quantity", Integer.TYPE), new MetadataItem("capdv", "capdv", Double.TYPE), new MetadataItem("scenario", "scenario", String.class)});
        Assertions.assertThat((List)f.apply((String)"their_prices").fields).containsExactlyInAnyOrder((Object[])new MetadataItem[]{new MetadataItem("competitor_ean", "competitor_ean", String.class), new MetadataItem("competitor_concurrent_pdv", "competitor_concurrent_pdv", String.class), new MetadataItem("competitor_brand", "competitor_brand", String.class), new MetadataItem("competitor_concurrent_ean", "competitor_concurrent_ean", String.class), new MetadataItem("competitor_price", "competitor_price", Double.TYPE)});
        Assertions.assertThat((List)f.apply((String)"our_stores_their_stores").fields).containsExactlyInAnyOrder((Object[])new MetadataItem[]{new MetadataItem("our_store", "our_store", String.class), new MetadataItem("their_store", "their_store", String.class)});
        Assertions.assertThat((List)metadataResultDto.aggregationFunctions).containsExactlyInAnyOrder((Object[])DuckDBQueryEngine.SUPPORTED_AGGREGATION_FUNCTIONS.toArray(new String[0]));
    }

    @Test
    void testScenarioGroupingQuery() throws Exception {
        BucketColumnSetDto bucketCS = new BucketColumnSetDto("group", TableField.tableField((String)"scenario")).withNewBucket("group1", List.of("base", "MN up")).withNewBucket("group2", List.of("base", "MN & MDD up")).withNewBucket("group3", List.of("base", "MN up", "MN & MDD up"));
        Measure aggregatedMeasure = Functions.sum((String)"capdv", (String)"capdv");
        ExpressionMeasure indicePrix = new ExpressionMeasure("indice_prix", "sum(capdv) / sum(competitor_price * quantity)");
        ComparisonMeasureReferencePosition aggregatedMeasureDiff = new ComparisonMeasureReferencePosition("aggregatedMeasureDiff", ComparisonMethod.ABSOLUTE_DIFFERENCE, aggregatedMeasure, Map.of(TableField.tableField((String)"scenario"), "s-1", TableField.tableField((String)"group"), "g"), ColumnSetKey.BUCKET);
        ComparisonMeasureReferencePosition indicePrixDiff = new ComparisonMeasureReferencePosition("indicePrixDiff", ComparisonMethod.ABSOLUTE_DIFFERENCE, (Measure)indicePrix, Map.of(TableField.tableField((String)"scenario"), "s-1", TableField.tableField((String)"group"), "g"), ColumnSetKey.BUCKET);
        QueryDto query = Query.from((String)"our_prices").join("our_stores_their_stores", JoinType.INNER).on(Functions.criterion((String)"our_prices.pdv", (String)"our_stores_their_stores.our_store", (ConditionType)ConditionType.EQ)).join("their_prices", JoinType.INNER).on(Functions.criterion((String)"their_prices.competitor_concurrent_pdv", (String)"our_stores_their_stores.their_store", (ConditionType)ConditionType.EQ)).select_(List.of(bucketCS), List.of(aggregatedMeasureDiff, indicePrixDiff)).build();
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/query", (Object[])new Object[0]).content(JacksonUtil.serialize((Object)query)).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(result -> {
            String contentAsString = result.getResponse().getContentAsString();
            QueryResultDto queryResult = (QueryResultDto)JacksonUtil.deserialize((String)contentAsString, QueryResultDto.class);
            double baseValue = 0.9803921568627451;
            double mnValue = 1.0294117647058822;
            double mnmddValue = 1.0784313725490196;
            Assertions.assertThat((List)queryResult.table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("group1", "base", Double.valueOf(0.0), Double.valueOf(0.0)), List.of("group1", "MN up", Double.valueOf(10000.0), Double.valueOf(mnValue - baseValue)), List.of("group2", "base", Double.valueOf(0.0), Double.valueOf(0.0)), List.of("group2", "MN & MDD up", Double.valueOf(20000.0), Double.valueOf(mnmddValue - baseValue)), List.of("group3", "base", Double.valueOf(0.0), Double.valueOf(0.0)), List.of("group3", "MN up", Double.valueOf(10000.0), Double.valueOf(mnValue - baseValue)), List.of("group3", "MN & MDD up", Double.valueOf(10000.0), Double.valueOf(mnmddValue - mnValue))});
            Assertions.assertThat((List)queryResult.table.columns).containsExactly((Object[])new String[]{"group", "scenario", "aggregatedMeasureDiff", "indicePrixDiff"});
        });
    }

    @Test
    void testQueryCache() {
        this.queryController.queryExecutor.queryCache.clear();
        QueryDto query = Query.from((String)"our_prices").select(List.of(), List.of(CountMeasure.INSTANCE)).build();
        DatasetTestConfig.squashQLUserSupplier.set((SquashQLUser)new BasicUser("paul"));
        BiConsumer<Long, Long> checker = (expectedHitCount, expectedMissCount) -> {
            try {
                this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/query", (Object[])new Object[0]).content(JacksonUtil.serialize((Object)query)).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(result -> {
                    String contentAsString = result.getResponse().getContentAsString();
                    QueryResultDto queryResult = (QueryResultDto)JacksonUtil.deserialize((String)contentAsString, QueryResultDto.class);
                    Assertions.assertThat((long)queryResult.debug.cache.hitCount).isEqualTo(expectedHitCount);
                    Assertions.assertThat((long)queryResult.debug.cache.missCount).isEqualTo(expectedMissCount);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        checker.accept(0L, 1L);
        checker.accept(1L, 1L);
        DatasetTestConfig.squashQLUserSupplier.set((SquashQLUser)new BasicUser("peter"));
        checker.accept(0L, 1L);
        DatasetTestConfig.squashQLUserSupplier.set(null);
    }

    @Test
    void testQueryMerge() throws Exception {
        QueryDto query1 = Query.from((String)"our_prices").select(TableField.tableFields(List.of("ean")), List.of(Functions.sum((String)"capdv-sum", (String)"capdv"))).build();
        QueryDto query2 = Query.from((String)"our_prices").select(TableField.tableFields(List.of("ean")), List.of(Functions.avg((String)"capdv-avg", (String)"capdv"))).build();
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/query-merge", (Object[])new Object[0]).content(JacksonUtil.serialize((Object)new QueryMergeDto(query1, query2, JoinType.FULL))).contentType(MediaType.APPLICATION_JSON)).andExpect(result -> {
            String contentAsString = result.getResponse().getContentAsString();
            QueryResultDto queryResult = (QueryResultDto)JacksonUtil.deserialize((String)contentAsString, QueryResultDto.class);
            Assertions.assertThat((List)queryResult.table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("ITMella 250g", Double.valueOf(102000.0), Double.valueOf(10200.0)), List.of("Nutella 250g", Double.valueOf(102000.0), Double.valueOf(10200.0))});
            Assertions.assertThat((List)queryResult.table.columns).containsExactly((Object[])new String[]{"ean", "capdv-sum", "capdv-avg"});
        });
    }
}

