/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.spring.dataset;

import com.google.common.collect.ImmutableList;
import io.squashql.DuckDBDatastore;
import io.squashql.jackson.JacksonUtil;
import io.squashql.query.AggregatedMeasure;
import io.squashql.query.Header;
import io.squashql.query.QueryExecutor;
import io.squashql.query.SquashQLUser;
import io.squashql.query.TableField;
import io.squashql.query.builder.Query;
import io.squashql.query.database.DuckDBQueryEngine;
import io.squashql.query.database.QueryEngine;
import io.squashql.query.dto.PivotTableQueryDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.SimpleTableDto;
import io.squashql.store.Store;
import io.squashql.table.PivotTable;
import io.squashql.transaction.DuckDBDataLoader;
import io.squashql.type.TableTypedField;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

@TestConfiguration
public class DatasetTestConfig {
    public static final AtomicReference<SquashQLUser> squashQLUserSupplier = new AtomicReference();

    @Bean
    public DuckDBQueryEngine queryEngine() {
        return new DuckDBQueryEngine(DatasetTestConfig.createTestDatastoreWithData());
    }

    @Bean
    public void displayPivotTable() {
        QueryExecutor queryExecutor = new QueryExecutor((QueryEngine)this.queryEngine());
        QueryDto query = Query.from((String)"our_prices").select(TableField.tableFields(List.of("ean", "pdv", "scenario")), List.of(new AggregatedMeasure("count", "*", "count"))).build();
        PivotTable pt = queryExecutor.execute(new PivotTableQueryDto(query, TableField.tableFields(List.of("pdv", "ean")), TableField.tableFields(List.of("scenario"))));
        pt.show();
        DatasetTestConfig.toJson(pt);
    }

    public static void toJson(PivotTable pivotTable) {
        List<String> list = pivotTable.table.headers().stream().map(Header::name).toList();
        SimpleTableDto simpleTable = SimpleTableDto.builder().rows((List)ImmutableList.copyOf((Iterator)pivotTable.table.iterator())).columns(list).build();
        Map<String, SimpleTableDto> data = Map.of("rows", pivotTable.rows, "columns", pivotTable.columns, "values", pivotTable.values, "table", simpleTable);
        String encodedString = Base64.getEncoder().encodeToString(JacksonUtil.serialize(data).getBytes(StandardCharsets.UTF_8));
        System.out.println("http://localhost:8080?data=" + encodedString);
    }

    @Bean
    public Supplier<SquashQLUser> squashQLUserSupplier() {
        return () -> squashQLUserSupplier.get();
    }

    public static DuckDBDatastore createTestDatastoreWithData() {
        TableTypedField ean = new TableTypedField("our_prices", "ean", String.class);
        TableTypedField pdv = new TableTypedField("our_prices", "pdv", String.class);
        TableTypedField price = new TableTypedField("our_prices", "price", Double.TYPE);
        TableTypedField qty = new TableTypedField("our_prices", "quantity", Integer.TYPE);
        TableTypedField capdv = new TableTypedField("our_prices", "capdv", Double.TYPE);
        TableTypedField compEan = new TableTypedField("their_prices", "competitor_ean", String.class);
        TableTypedField compConcurrentPdv = new TableTypedField("their_prices", "competitor_concurrent_pdv", String.class);
        TableTypedField compBrand = new TableTypedField("their_prices", "competitor_brand", String.class);
        TableTypedField compConcurrentEan = new TableTypedField("their_prices", "competitor_concurrent_ean", String.class);
        TableTypedField compPrice = new TableTypedField("their_prices", "competitor_price", Double.TYPE);
        Store our_price_store = new Store("our_prices", List.of(ean, pdv, price, qty, capdv));
        Store their_prices_store = new Store("their_prices", List.of(compEan, compConcurrentPdv, compBrand, compConcurrentEan, compPrice));
        Store our_stores_their_stores_store = new Store("our_stores_their_stores", List.of(new TableTypedField("our_stores_their_stores", "our_store", String.class), new TableTypedField("our_stores_their_stores", "their_store", String.class)));
        DuckDBDatastore datastore = new DuckDBDatastore();
        DuckDBDataLoader tm = new DuckDBDataLoader(datastore);
        tm.createOrReplaceTable(our_price_store.name(), our_price_store.fields());
        tm.createOrReplaceTable(their_prices_store.name(), their_prices_store.fields(), false);
        tm.createOrReplaceTable(our_stores_their_stores_store.name(), our_stores_their_stores_store.fields(), false);
        tm.load("base", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}));
        tm.load("MN up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}));
        tm.load("MDD up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}));
        tm.load("MN & MDD up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}));
        tm.load("MN & MDD down", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 9.0, 1000, 9000.0}, new Object[]{"ITMella 250g", "ITM Balma", 9.0, 1000, 9000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 9.0, 1000, 9000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 9.0, 1000, 9000.0}));
        tm.load("their_prices", List.of(new Object[]{"Nutella 250g", "Leclerc Rouffiac", "Leclerc", "Nutella 250g", 9.0}, new Object[]{"Nutella 250g", "Auchan Toulouse", "Auchan", "Nutella 250g", 11.0}, new Object[]{"Nutella 250g", "Auchan Ponts Jumeaux", "Auchan", "Nutella 250g", 11.0}, new Object[]{"Nutella 250g", "Auchan Launaguet", "Auchan", "Nutella 250g", 9.0}, new Object[]{"ITMella 250g", "Leclerc Rouffiac", "Leclerc", "LeclercElla", 9.0}, new Object[]{"ITMella 250g", "Auchan Toulouse", "Auchan", "AuchanElla", 11.0}, new Object[]{"ITMella 250g", "Auchan Launaguet", "Auchan", "AuchanElla", 9.0}));
        tm.load("our_stores_their_stores", List.of(new Object[]{"ITM Balma", "Leclerc Rouffiac"}, new Object[]{"ITM Balma", "Auchan Toulouse"}, new Object[]{"ITM Balma", "Auchan Ponts Jumeaux"}, new Object[]{"ITM Toulouse and Drive", "Auchan Launaguet"}, new Object[]{"ITM Toulouse and Drive", "Auchan Toulouse"}, new Object[]{"ITM Toulouse and Drive", "Auchan Ponts Jumeaux"}));
        return datastore;
    }
}

