/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.spring.web.rest;

import io.squashql.query.Header;
import io.squashql.query.Measure;
import io.squashql.query.MeasureUtils;
import io.squashql.query.QueryExecutor;
import io.squashql.query.SquashQLUser;
import io.squashql.query.database.QueryEngine;
import io.squashql.query.dto.CacheStatsDto;
import io.squashql.query.dto.DebugInfoDto;
import io.squashql.query.dto.MetadataItem;
import io.squashql.query.dto.MetadataResultDto;
import io.squashql.query.dto.PivotTableQueryDto;
import io.squashql.query.dto.PivotTableQueryMergeDto;
import io.squashql.query.dto.PivotTableQueryResultDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryJoinDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.QueryResultDto;
import io.squashql.spring.web.rest.JacksonConfiguration;
import io.squashql.spring.web.rest.SquashQLErrorHandler;
import io.squashql.store.Store;
import io.squashql.table.PivotTable;
import io.squashql.table.PivotTableUtils;
import io.squashql.table.Table;
import io.squashql.table.TableUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Import;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Import(value={JacksonConfiguration.class, SquashQLErrorHandler.class})
@RestController
public class QueryController {
    public static final String MAPPING_QUERY = "/query";
    public static final String MAPPING_QUERY_STRINGIFY = "/query-stringify";
    public static final String MAPPING_QUERY_MERGE = "/query-merge";
    public static final String MAPPING_QUERY_MERGE_STRINGIFY = "/query-merge-stringify";
    public static final String MAPPING_QUERY_JOIN_EXPERIMENTAL = "/experimental/query-join";
    public static final String MAPPING_QUERY_PIVOT = "/query-pivot";
    public static final String MAPPING_QUERY_PIVOT_STRINGIFY = "/query-pivot-stringify";
    public static final String MAPPING_QUERY_MERGE_PIVOT = "/query-merge-pivot";
    public static final String MAPPING_QUERY_MERGE_PIVOT_STRINGIFY = "/query-merge-pivot-stringify";
    public static final String MAPPING_METADATA = "/metadata";
    public static final String MAPPING_EXPRESSION = "/expression";
    protected final QueryEngine<?> queryEngine;
    public final QueryExecutor queryExecutor;
    protected final Supplier<SquashQLUser> squashQLUserSupplier;

    public QueryController(QueryEngine<?> queryEngine, Optional<Supplier<SquashQLUser>> squashQLUserSupplier) {
        this.queryEngine = queryEngine;
        this.queryExecutor = new QueryExecutor(this.queryEngine);
        this.squashQLUserSupplier = squashQLUserSupplier.orElse(null);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<QueryResultDto> execute(@RequestBody QueryDto query) {
        CacheStatsDto.CacheStatsDtoBuilder csBuilder = CacheStatsDto.builder();
        Table table = this.queryExecutor.executeQuery(query, csBuilder, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get(), true, null);
        return ResponseEntity.ok((Object)QueryController.createQueryResultDto(table, csBuilder, query.minify));
    }

    @PostMapping(value={"/query-pivot"})
    public ResponseEntity<PivotTableQueryResultDto> execute(@RequestBody PivotTableQueryDto pivotTableQueryDto) {
        CacheStatsDto.CacheStatsDtoBuilder csBuilder = CacheStatsDto.builder();
        PivotTable pt = this.queryExecutor.executePivotQuery(pivotTableQueryDto, csBuilder, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get(), true, null);
        List cells = PivotTableUtils.generateCells((PivotTable)pt, (Boolean)pivotTableQueryDto.query.minify);
        return ResponseEntity.ok((Object)new PivotTableQueryResultDto(cells, pt.rows, pt.columns, pt.values, pt.hiddenTotals));
    }

    @PostMapping(value={"/query-merge"})
    public ResponseEntity<QueryResultDto> executeAndMerge(@RequestBody QueryMergeDto queryMergeDto) {
        Table table = this.queryExecutor.executeQueryMerge(queryMergeDto, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get());
        return ResponseEntity.ok((Object)QueryController.createQueryResultDto(table, CacheStatsDto.builder(), queryMergeDto.minify));
    }

    @PostMapping(value={"/query-merge-pivot"})
    public ResponseEntity<PivotTableQueryResultDto> executeQueryMergePivot(@RequestBody PivotTableQueryMergeDto pivotTableQueryMergeDto) {
        PivotTable pt = this.queryExecutor.executePivotQueryMerge(pivotTableQueryMergeDto, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get());
        List cells = PivotTableUtils.generateCells((PivotTable)pt, (Boolean)pivotTableQueryMergeDto.query.minify);
        return ResponseEntity.ok((Object)new PivotTableQueryResultDto(cells, pt.rows, pt.columns, pt.values, pt.hiddenTotals));
    }

    @PostMapping(value={"/experimental/query-join"})
    public ResponseEntity<QueryResultDto> executeQueryJoin(@RequestBody QueryJoinDto queryJoinDto) {
        Table table = this.queryExecutor.executeExperimentalQueryMerge(queryJoinDto);
        return ResponseEntity.ok((Object)QueryController.createQueryResultDto(table, CacheStatsDto.builder(), queryJoinDto.minify));
    }

    private static QueryResultDto createQueryResultDto(Table table, CacheStatsDto.CacheStatsDtoBuilder csBuilder, Boolean minify) {
        List fields = table.headers().stream().map(Header::name).collect(Collectors.toList());
        QueryResultDto result = QueryResultDto.builder().columns(fields).cells(TableUtils.generateCells((Table)table, (Boolean)minify)).metadata(TableUtils.buildTableMetadata((Table)table)).debug(DebugInfoDto.builder().cache(csBuilder.build()).build()).build();
        return result;
    }

    @PostMapping(value={"/query-stringify"})
    public ResponseEntity<String> executeStringify(@RequestBody QueryDto query) {
        Table table = this.queryExecutor.executeQuery(query);
        return ResponseEntity.ok((Object)table.toString());
    }

    @PostMapping(value={"/query-merge-stringify"})
    public ResponseEntity<String> executeAndMergeStringify(@RequestBody QueryMergeDto queryMergeDto) {
        Table table = this.queryExecutor.executeQueryMerge(queryMergeDto, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get());
        return ResponseEntity.ok((Object)table.toString());
    }

    @PostMapping(value={"/query-pivot-stringify"})
    public ResponseEntity<String> executePivotStringify(@RequestBody PivotTableQueryDto query) {
        PivotTable table = this.queryExecutor.executePivotQuery(query);
        return ResponseEntity.ok((Object)table.toString());
    }

    @PostMapping(value={"/query-merge-pivot-stringify"})
    public ResponseEntity<String> executeAndMergePivotStringify(@RequestBody PivotTableQueryMergeDto pivotTableQueryMergeDto) {
        PivotTable pt = this.queryExecutor.executePivotQueryMerge(pivotTableQueryMergeDto, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get());
        return ResponseEntity.ok((Object)pt.toString());
    }

    @GetMapping(value={"/metadata"})
    public ResponseEntity<MetadataResultDto> getMetadata() {
        ArrayList<MetadataResultDto.StoreMetadata> stores = new ArrayList<MetadataResultDto.StoreMetadata>();
        for (Store store : this.queryEngine.datastore().storeByName().values()) {
            List<MetadataItem> items = store.fields().stream().map(f -> new MetadataItem(f.name(), f.name(), f.type())).toList();
            stores.add(new MetadataResultDto.StoreMetadata(store.name(), items));
        }
        return ResponseEntity.ok((Object)new MetadataResultDto(stores, this.queryEngine.supportedAggregationFunctions(), Collections.emptyList()));
    }

    @PostMapping(value={"/expression"})
    public ResponseEntity<List<Measure>> setMeasureExpressions(@RequestBody List<Measure> measures) {
        ArrayList<Measure> res = new ArrayList<Measure>(measures.size());
        for (Measure measure : measures) {
            String expression = measure.expression();
            Measure m = measure;
            if (expression == null) {
                m = measure.withExpression(MeasureUtils.createExpression((Measure)measure));
            }
            res.add(m);
        }
        return ResponseEntity.ok(res);
    }
}

