/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.spring.web.rest;

import com.google.common.collect.ImmutableList;
import io.squashql.query.Header;
import io.squashql.query.Measure;
import io.squashql.query.MeasureUtils;
import io.squashql.query.QueryExecutor;
import io.squashql.query.SquashQLUser;
import io.squashql.query.Table;
import io.squashql.query.TableUtils;
import io.squashql.query.database.QueryEngine;
import io.squashql.query.dto.CacheStatsDto;
import io.squashql.query.dto.DebugInfoDto;
import io.squashql.query.dto.MetadataItem;
import io.squashql.query.dto.MetadataResultDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.QueryResultDto;
import io.squashql.query.dto.SimpleTableDto;
import io.squashql.query.monitoring.QueryWatch;
import io.squashql.store.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QueryController {
    public static final String MAPPING_QUERY = "/query";
    public static final String MAPPING_QUERY_MERGE = "/query-merge";
    public static final String MAPPING_QUERY_RAW = "/query-raw";
    public static final String MAPPING_QUERY_BEAUTIFY = "/query-beautify";
    public static final String MAPPING_METADATA = "/metadata";
    public static final String MAPPING_EXPRESSION = "/expression";
    protected final QueryEngine<?> queryEngine;
    protected final QueryExecutor queryExecutor;
    protected final Supplier<SquashQLUser> squashQLUserSupplier;

    public QueryController(QueryEngine<?> queryEngine, Optional<Supplier<SquashQLUser>> squashQLUserSupplier) {
        this.queryEngine = queryEngine;
        this.queryExecutor = new QueryExecutor(this.queryEngine);
        this.squashQLUserSupplier = squashQLUserSupplier.orElse(null);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<QueryResultDto> execute(@RequestBody QueryDto query) {
        QueryWatch queryWatch = new QueryWatch();
        CacheStatsDto.CacheStatsDtoBuilder csBuilder = CacheStatsDto.builder();
        Table table = this.queryExecutor.execute(query, queryWatch, csBuilder, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get(), true, null);
        List fields = table.headers().stream().map(Header::name).collect(Collectors.toList());
        SimpleTableDto simpleTable = SimpleTableDto.builder().rows((List)ImmutableList.copyOf((Iterator)table.iterator())).columns(fields).build();
        QueryResultDto result = QueryResultDto.builder().table(simpleTable).metadata(TableUtils.buildTableMetadata((Table)table)).debug(DebugInfoDto.builder().cache(csBuilder.build()).timings(queryWatch.toQueryTimings()).build()).build();
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/query-merge"})
    public ResponseEntity<QueryResultDto> executeAndMerge(@RequestBody QueryMergeDto queryMergeDto) {
        Table table = this.queryExecutor.execute(queryMergeDto.first, queryMergeDto.second, queryMergeDto.joinType, this.squashQLUserSupplier == null ? null : this.squashQLUserSupplier.get());
        List fields = table.headers().stream().map(Header::name).collect(Collectors.toList());
        SimpleTableDto simpleTable = SimpleTableDto.builder().rows((List)ImmutableList.copyOf((Iterator)table.iterator())).columns(fields).build();
        QueryResultDto result = QueryResultDto.builder().table(simpleTable).metadata(TableUtils.buildTableMetadata((Table)table)).build();
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/query-beautify"})
    public ResponseEntity<String> executeBeautify(@RequestBody QueryDto query) {
        Table table = this.queryExecutor.execute(query);
        return ResponseEntity.ok((Object)table.toString());
    }

    @PostMapping(value={"/query-raw"})
    public ResponseEntity<QueryResultDto> executeRaw(@RequestBody String sql) {
        Table table = this.queryExecutor.execute(sql);
        SimpleTableDto simpleTable = SimpleTableDto.builder().rows((List)ImmutableList.copyOf((Iterator)table.iterator())).columns(table.headers().stream().map(header -> header.name()).collect(Collectors.toList())).build();
        QueryResultDto result = QueryResultDto.builder().table(simpleTable).build();
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/metadata"})
    public ResponseEntity<MetadataResultDto> getMetadata() {
        ArrayList<MetadataResultDto.StoreMetadata> stores = new ArrayList<MetadataResultDto.StoreMetadata>();
        for (Store store : this.queryEngine.datastore().storesByName().values()) {
            List<MetadataItem> items = store.fields().stream().map(f -> new MetadataItem(f.name(), f.name(), f.type())).toList();
            stores.add(new MetadataResultDto.StoreMetadata(store.name(), items));
        }
        return ResponseEntity.ok((Object)new MetadataResultDto(stores, this.queryEngine.supportedAggregationFunctions(), Collections.emptyList()));
    }

    @PostMapping(value={"/expression"})
    public ResponseEntity<List<Measure>> setMeasureExpressions(@RequestBody List<Measure> measures) {
        ArrayList<Measure> res = new ArrayList<Measure>(measures.size());
        for (Measure measure : measures) {
            String expression = measure.expression();
            Measure m = measure;
            if (expression == null) {
                m = measure.withExpression(MeasureUtils.createExpression((Measure)measure));
            }
            res.add(m);
        }
        return ResponseEntity.ok(res);
    }
}

