/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.spring.dataset;

import io.squashql.SparkDatastore;
import io.squashql.query.SquashQLUser;
import io.squashql.query.database.SparkQueryEngine;
import io.squashql.store.Field;
import io.squashql.store.Store;
import io.squashql.transaction.SparkDataLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.spark.sql.SparkSession;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

@TestConfiguration
public class DatasetTestConfig {
    public static final AtomicReference<SquashQLUser> squashQLUserSupplier = new AtomicReference();

    @Bean
    public SparkQueryEngine queryEngine() {
        return new SparkQueryEngine(DatasetTestConfig.createTestDatastoreWithData());
    }

    @Bean
    public Supplier<SquashQLUser> squashQLUserSupplier() {
        return () -> squashQLUserSupplier.get();
    }

    public static SparkDatastore createTestDatastoreWithData() {
        Field ean = new Field("our_prices", "ean", String.class);
        Field pdv = new Field("our_prices", "pdv", String.class);
        Field price = new Field("our_prices", "price", Double.TYPE);
        Field qty = new Field("our_prices", "quantity", Integer.TYPE);
        Field capdv = new Field("our_prices", "capdv", Double.TYPE);
        Field compEan = new Field("their_prices", "competitor_ean", String.class);
        Field compConcurrentPdv = new Field("their_prices", "competitor_concurrent_pdv", String.class);
        Field compBrand = new Field("their_prices", "competitor_brand", String.class);
        Field compConcurrentEan = new Field("their_prices", "competitor_concurrent_ean", String.class);
        Field compPrice = new Field("their_prices", "competitor_price", Double.TYPE);
        Store our_price_store = new Store("our_prices", List.of(ean, pdv, price, qty, capdv));
        Store their_prices_store = new Store("their_prices", List.of(compEan, compConcurrentPdv, compBrand, compConcurrentEan, compPrice));
        Store our_stores_their_stores_store = new Store("our_stores_their_stores", List.of(new Field("our_stores_their_stores", "our_store", String.class), new Field("our_stores_their_stores", "their_store", String.class)));
        SparkDatastore datastore = new SparkDatastore();
        SparkDataLoader tm = new SparkDataLoader(datastore.spark);
        tm.createTemporaryTable(our_price_store.name(), our_price_store.fields());
        SparkDataLoader.createTemporaryTable((SparkSession)datastore.spark, (String)their_prices_store.name(), (List)their_prices_store.fields(), (boolean)false);
        SparkDataLoader.createTemporaryTable((SparkSession)datastore.spark, (String)our_stores_their_stores_store.name(), (List)our_stores_their_stores_store.fields(), (boolean)false);
        tm.load("base", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}));
        tm.load("MN up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}));
        tm.load("MDD up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 10.0, 1000, 10000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}));
        tm.load("MN & MDD up", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Balma", 11.0, 1000, 11000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 11.0, 1000, 11000.0}));
        tm.load("MN & MDD down", "our_prices", List.of(new Object[]{"Nutella 250g", "ITM Balma", 9.0, 1000, 9000.0}, new Object[]{"ITMella 250g", "ITM Balma", 9.0, 1000, 9000.0}, new Object[]{"Nutella 250g", "ITM Toulouse and Drive", 9.0, 1000, 9000.0}, new Object[]{"ITMella 250g", "ITM Toulouse and Drive", 9.0, 1000, 9000.0}));
        tm.load("base", "their_prices", List.of(new Object[]{"Nutella 250g", "Leclerc Rouffiac", "Leclerc", "Nutella 250g", 9.0}, new Object[]{"Nutella 250g", "Auchan Toulouse", "Auchan", "Nutella 250g", 11.0}, new Object[]{"Nutella 250g", "Auchan Ponts Jumeaux", "Auchan", "Nutella 250g", 11.0}, new Object[]{"Nutella 250g", "Auchan Launaguet", "Auchan", "Nutella 250g", 9.0}, new Object[]{"ITMella 250g", "Leclerc Rouffiac", "Leclerc", "LeclercElla", 9.0}, new Object[]{"ITMella 250g", "Auchan Toulouse", "Auchan", "AuchanElla", 11.0}, new Object[]{"ITMella 250g", "Auchan Launaguet", "Auchan", "AuchanElla", 9.0}));
        tm.load("base", "our_stores_their_stores", List.of(new Object[]{"ITM Balma", "Leclerc Rouffiac"}, new Object[]{"ITM Balma", "Auchan Toulouse"}, new Object[]{"ITM Balma", "Auchan Ponts Jumeaux"}, new Object[]{"ITM Toulouse and Drive", "Auchan Launaguet"}, new Object[]{"ITM Toulouse and Drive", "Auchan Toulouse"}, new Object[]{"ITM Toulouse and Drive", "Auchan Ponts Jumeaux"}));
        return datastore;
    }
}

