/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.client;

import io.squashql.client.http.HttpClientQuerier;
import io.squashql.query.AggregatedMeasure;
import io.squashql.query.ColumnSetKey;
import io.squashql.query.ComparisonMeasureReferencePosition;
import io.squashql.query.ComparisonMethod;
import io.squashql.query.Functions;
import io.squashql.query.Measure;
import io.squashql.query.builder.Query;
import io.squashql.query.dto.BucketColumnSetDto;
import io.squashql.query.dto.MetadataItem;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.QueryResultDto;
import io.squashql.query.dto.SimpleTableDto;
import io.squashql.spring.SquashQLApplication;
import io.squashql.spring.dataset.DatasetTestConfig;
import io.squashql.spring.web.rest.QueryControllerTest;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.context.annotation.Import;

@SpringBootTest(classes={SquashQLApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.main.allow-bean-definition-overriding=true"})
@Import(value={DatasetTestConfig.class})
public class HttpClientQuerierTest {
    @LocalServerPort
    int port;

    String url() {
        return "http://127.0.0.1:" + this.port;
    }

    @Test
    void testGetMetadata() {
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        QueryControllerTest.assertMetadataResult(querier.metadata());
    }

    @Test
    void testRunQuery() {
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        QueryDto query = new QueryDto().table("our_prices").withColumn("scenario").aggregatedMeasure("qs", "quantity", "sum");
        QueryResultDto response = querier.run(query);
        HttpClientQuerierTest.assertQuery(response.table);
        Assertions.assertThat((List)response.metadata).containsExactly((Object[])new MetadataItem[]{new MetadataItem("scenario", "scenario", String.class), new MetadataItem("qs", "sum(quantity)", Long.TYPE)});
        Assertions.assertThat((Object)response.debug.cache).isNotNull();
        Assertions.assertThat((Object)response.debug.timings).isNotNull();
    }

    @Test
    void testMergeQuery() {
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        QueryDto query1 = new QueryDto().table("our_prices").withColumn("scenario").aggregatedMeasure("qs", "quantity", "sum");
        QueryDto query2 = new QueryDto().table("our_prices").withColumn("scenario").aggregatedMeasure("qa", "quantity", "avg");
        QueryResultDto response = querier.queryMerge(new QueryMergeDto(query1, query2));
        Assertions.assertThat((List)response.table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("MDD up", Integer.valueOf(4000), Double.valueOf(1000.0)), List.of("MN & MDD down", Integer.valueOf(4000), Double.valueOf(1000.0)), List.of("MN & MDD up", Integer.valueOf(4000), Double.valueOf(1000.0)), List.of("MN up", Integer.valueOf(4000), Double.valueOf(1000.0)), List.of("base", Integer.valueOf(4000), Double.valueOf(1000.0))});
        Assertions.assertThat((List)response.table.columns).containsExactly((Object[])new String[]{"scenario", "qs", "qa"});
        Assertions.assertThat((List)response.metadata).containsExactly((Object[])new MetadataItem[]{new MetadataItem("scenario", "scenario", String.class), new MetadataItem("qs", "sum(quantity)", Long.TYPE), new MetadataItem("qa", "avg(quantity)", Double.TYPE)});
        Assertions.assertThat((Object)response.debug).isNull();
    }

    @Test
    void testRunGroupingScenarioQuery() {
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        BucketColumnSetDto bucketCS = new BucketColumnSetDto("group", "scenario").withNewBucket("group1", List.of("base", "MN up")).withNewBucket("group2", List.of("base", "MN & MDD up")).withNewBucket("group3", List.of("base", "MN up", "MN & MDD up"));
        Measure aggregatedMeasure = Functions.sum((String)"capdv", (String)"capdv");
        ComparisonMeasureReferencePosition capdvDiff = new ComparisonMeasureReferencePosition("capdvDiff", ComparisonMethod.ABSOLUTE_DIFFERENCE, aggregatedMeasure, Map.of("scenario", "first", "group", "g"), ColumnSetKey.BUCKET);
        QueryDto query = Query.from((String)"our_prices").select_(List.of(bucketCS), List.of(capdvDiff, aggregatedMeasure)).build();
        QueryResultDto response = querier.run(query);
        SimpleTableDto table = response.table;
        double baseValue = 40000.0;
        double mnValue = 42000.0;
        double mnmddValue = 44000.0;
        Assertions.assertThat((List)table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("group1", "base", Double.valueOf(0.0), Double.valueOf(baseValue)), List.of("group1", "MN up", Double.valueOf(mnValue - baseValue), Double.valueOf(mnValue)), List.of("group2", "base", Double.valueOf(0.0), Double.valueOf(baseValue)), List.of("group2", "MN & MDD up", Double.valueOf(mnmddValue - baseValue), Double.valueOf(mnmddValue)), List.of("group3", "base", Double.valueOf(0.0), Double.valueOf(baseValue)), List.of("group3", "MN up", Double.valueOf(mnValue - baseValue), Double.valueOf(mnValue)), List.of("group3", "MN & MDD up", Double.valueOf(mnmddValue - baseValue), Double.valueOf(mnmddValue))});
        Assertions.assertThat((List)table.columns).containsExactly((Object[])new String[]{"group", "scenario", "capdvDiff", "capdv"});
    }

    @Test
    void testRunQueryWithCondition() {
        QueryDto query = Query.from((String)"our_prices").where("scenario", Functions.eq((Object)"base")).select(List.of("scenario", "pdv"), List.of(Functions.sum((String)"ps", (String)"price"))).build();
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        QueryResultDto response = querier.run(query);
        SimpleTableDto table = response.table;
        Assertions.assertThat((List)table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("base", "ITM Balma", Double.valueOf(20.0)), List.of("base", "ITM Toulouse and Drive", Double.valueOf(20.0))});
        Assertions.assertThat((List)table.columns).containsExactly((Object[])new String[]{"scenario", "pdv", "ps"});
    }

    static void assertQuery(SimpleTableDto table) {
        Assertions.assertThat((List)table.rows).containsExactlyInAnyOrder((Object[])new List[]{List.of("MDD up", Integer.valueOf(4000)), List.of("MN & MDD down", Integer.valueOf(4000)), List.of("MN & MDD up", Integer.valueOf(4000)), List.of("MN up", Integer.valueOf(4000)), List.of("base", Integer.valueOf(4000))});
        Assertions.assertThat((List)table.columns).containsExactly((Object[])new String[]{"scenario", "qs"});
    }

    @Test
    void testSetExpressions() {
        AggregatedMeasure a = new AggregatedMeasure("a", "a", "sum");
        AggregatedMeasure b = new AggregatedMeasure("b", "b", "sum");
        Measure plus = Functions.plus((String)"a+b", (Measure)a, (Measure)b);
        List<Measure> input = Stream.of(a, b, plus).map(m -> m.withExpression(null)).toList();
        HttpClientQuerier querier = new HttpClientQuerier(this.url());
        List expression = querier.expression(input);
        Assertions.assertThat(expression.stream().map(Measure::expression)).containsExactly((Object[])new String[]{"sum(a)", "sum(b)", "a + b"});
    }

    static {
        TomcatURLStreamHandlerFactory.disable();
    }
}

