/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.js;

import io.squashql.jackson.JacksonUtil;
import io.squashql.query.AggregatedMeasure;
import io.squashql.query.BasicMeasure;
import io.squashql.query.BinaryOperationMeasure;
import io.squashql.query.BinaryOperator;
import io.squashql.query.ColumnSet;
import io.squashql.query.ColumnSetKey;
import io.squashql.query.ComparisonMeasureReferencePosition;
import io.squashql.query.ComparisonMethod;
import io.squashql.query.CountMeasure;
import io.squashql.query.ExpressionMeasure;
import io.squashql.query.Functions;
import io.squashql.query.Measure;
import io.squashql.query.builder.Query;
import io.squashql.query.dto.BucketColumnSetDto;
import io.squashql.query.dto.ConditionDto;
import io.squashql.query.dto.CriteriaDto;
import io.squashql.query.dto.JoinMappingDto;
import io.squashql.query.dto.JoinType;
import io.squashql.query.dto.OrderKeywordDto;
import io.squashql.query.dto.Period;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.TableDto;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJavascriptLibrary {
    @Test
    void testReadJsonBuildFromQueryDto() throws IOException {
        TableDto table = new TableDto("myTable");
        TableDto refTable = new TableDto("refTable");
        table.innerJoin(refTable, "fromField", "toField");
        table.join(new TableDto("a"), JoinType.LEFT, new JoinMappingDto("a", "a_id", "myTable", "id"));
        QueryDto q = new QueryDto().table(table).withColumn("a").withColumn("b");
        AggregatedMeasure price = new AggregatedMeasure("price.sum", "price", "sum");
        q.withMeasure((Measure)price);
        AggregatedMeasure priceFood = new AggregatedMeasure("alias", "price", "sum", Functions.criterion((String)"category", (ConditionDto)Functions.eq((Object)"food")));
        q.withMeasure((Measure)priceFood);
        BinaryOperationMeasure plus = new BinaryOperationMeasure("plusMeasure", BinaryOperator.PLUS, (Measure)price, (Measure)priceFood);
        q.withMeasure((Measure)plus);
        ExpressionMeasure expression = new ExpressionMeasure("myExpression", "sum(price*quantity)");
        q.withMeasure((Measure)expression);
        q.withMeasure((Measure)CountMeasure.INSTANCE);
        q.withMeasure(Functions.integer((long)123L));
        q.withMeasure(Functions.decimal((double)1.23));
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("comp bucket", ComparisonMethod.ABSOLUTE_DIFFERENCE, (Measure)price, Map.of("scenario", "s-1", "group", "g"), ColumnSetKey.BUCKET));
        Period.Month month = new Period.Month("mois", "annee");
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("growth", ComparisonMethod.DIVIDE, (Measure)price, Map.of("Annee", "y-1", "Mois", "m"), (Period)month));
        q.withMeasure((Measure)new ComparisonMeasureReferencePosition("parent", ComparisonMethod.DIVIDE, (Measure)price, List.of("Mois", "Annee")));
        ConditionDto queryCondition = Functions.or((ConditionDto)Functions.and((ConditionDto)Functions.eq((Object)"a"), (ConditionDto)Functions.eq((Object)"b"), (ConditionDto[])new ConditionDto[0]), (ConditionDto)Functions.lt((Object)5), (ConditionDto[])new ConditionDto[]{Functions.like((String)"a%")});
        q.withCondition("f1", queryCondition);
        q.withCondition("f2", Functions.gt((Object)659));
        q.withCondition("f3", Functions.in((Object[])new Object[]{0, 1, 2}));
        q.withCondition("f4", Functions.isNull());
        q.withCondition("f5", Functions.isNotNull());
        q.withHavingCriteria(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((BasicMeasure)price, (ConditionDto)Functions.ge((Object)10)), Functions.criterion((BasicMeasure)expression, (ConditionDto)Functions.lt((Object)100))}));
        q.orderBy("a", OrderKeywordDto.ASC);
        q.orderBy("b", List.of("1", "l", "p"));
        BucketColumnSetDto columnSet = new BucketColumnSetDto("group", "scenario").withNewBucket("a", List.of("a1", "a2")).withNewBucket("b", List.of("b1", "b2"));
        q.withColumnSet(ColumnSetKey.BUCKET, (ColumnSet)columnSet);
        QueryDto subQuery = new QueryDto().table(table).withColumn("aa").withMeasure(Functions.sum((String)"sum_aa", (String)"f"));
        q.table(subQuery);
        String name = "build-from-querydto.json";
        File file = new File(this.getClass().getClassLoader().getResource(name).getFile());
        QueryDto qjs = (QueryDto)JacksonUtil.deserialize((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), QueryDto.class);
        Assertions.assertThat((Map)q.columnSets).isEqualTo((Object)qjs.columnSets);
        Assertions.assertThat((List)q.columns).isEqualTo((Object)qjs.columns);
        Assertions.assertThat((List)q.rollupColumns).isEqualTo((Object)qjs.rollupColumns);
        Assertions.assertThat((Map)q.context).isEqualTo((Object)qjs.context);
        Assertions.assertThat((Map)q.orders).isEqualTo((Object)qjs.orders);
        Assertions.assertThat((List)q.measures).isEqualTo((Object)qjs.measures);
        Assertions.assertThat((Object)q.whereCriteriaDto).isEqualTo((Object)qjs.whereCriteriaDto);
        Assertions.assertThat((Object)q.table).isEqualTo((Object)qjs.table);
        Assertions.assertThat((Object)q.subQuery).isEqualTo((Object)qjs.subQuery);
        Assertions.assertThat((Object)q).isEqualTo((Object)qjs);
    }

    @Test
    void testReadJsonBuildFromQuery() throws IOException {
        TableDto table = new TableDto("myTable");
        TableDto refTable = new TableDto("refTable");
        BucketColumnSetDto bucketColumnSet = new BucketColumnSetDto("group", "scenario").withNewBucket("a", List.of("a1", "a2")).withNewBucket("b", List.of("b1", "b2"));
        Measure measure = Functions.sum((String)"sum", (String)"f1");
        ExpressionMeasure measureExpr = new ExpressionMeasure("sum_expr", "sum(f1)");
        QueryDto q = Query.from((String)table.name).innerJoin(refTable.name).on("myTable", "id", "refTable", "id").on("myTable", "a", "refTable", "a").where("f2", Functions.gt((Object)659)).where("f3", Functions.eq((Object)123)).select(List.of("a", "b"), List.of(bucketColumnSet), List.of(measure, Functions.avg((String)"sum", (String)"f1"), measureExpr)).rollup(new String[]{"a", "b"}).having(Functions.all((CriteriaDto[])new CriteriaDto[]{Functions.criterion((BasicMeasure)((BasicMeasure)measure), (ConditionDto)Functions.gt((Object)0)), Functions.criterion((BasicMeasure)((BasicMeasure)measureExpr), (ConditionDto)Functions.lt((Object)10))})).orderBy("f4", OrderKeywordDto.ASC).build();
        String name = "build-from-query.json";
        File file = new File(this.getClass().getClassLoader().getResource(name).getFile());
        QueryDto qjs = (QueryDto)JacksonUtil.deserialize((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), QueryDto.class);
        Assertions.assertThat((Map)q.columnSets).isEqualTo((Object)qjs.columnSets);
        Assertions.assertThat((List)q.columns).isEqualTo((Object)qjs.columns);
        Assertions.assertThat((List)q.rollupColumns).isEqualTo((Object)qjs.rollupColumns);
        Assertions.assertThat((Map)q.context).isEqualTo((Object)qjs.context);
        Assertions.assertThat((Map)q.orders).isEqualTo((Object)qjs.orders);
        Assertions.assertThat((List)q.measures).isEqualTo((Object)qjs.measures);
        Assertions.assertThat((Object)q.whereCriteriaDto).isEqualTo((Object)qjs.whereCriteriaDto);
        Assertions.assertThat((Object)q.table).isEqualTo((Object)qjs.table);
        Assertions.assertThat((Object)q.subQuery).isEqualTo((Object)qjs.subQuery);
        Assertions.assertThat((Object)q).isEqualTo((Object)qjs);
    }

    @Test
    void testReadJsonBuildFromQueryMerge() throws IOException {
        TableDto table = new TableDto("myTable");
        QueryDto q1 = Query.from((String)table.name).select(List.of("a", "b"), List.of(Functions.sum((String)"sum", (String)"f1"))).build();
        QueryDto q2 = Query.from((String)table.name).select(List.of("a", "b"), List.of(Functions.avg((String)"sum", (String)"f1"))).build();
        QueryMergeDto query = new QueryMergeDto(q1, q2);
        String name = "build-from-query-merge.json";
        File file = new File(this.getClass().getClassLoader().getResource(name).getFile());
        QueryMergeDto qjs = (QueryMergeDto)JacksonUtil.deserialize((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), QueryMergeDto.class);
        Assertions.assertThat((Object)qjs).isEqualTo((Object)query);
    }
}

