/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseValue;
import io.squashql.ClickHouseDatastore;
import io.squashql.ClickHouseUtil;
import io.squashql.query.database.AQueryEngine;
import io.squashql.query.database.DatabaseQuery;
import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SqlUtils;
import io.squashql.store.Datastore;
import io.squashql.table.ColumnarTable;
import io.squashql.table.RowTable;
import io.squashql.table.Table;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.tuple.Pair;

public class ClickHouseQueryEngine
extends AQueryEngine<ClickHouseDatastore> {
    public static final List<String> SUPPORTED_AGGREGATION_FUNCTIONS = List.of("count", "min", "max", "sum", "avg", "any", "stddevPop", "stddevSamp", "varPop", "varSamp", "covarPop", "covarSamp");
    protected final ClickHouseNodes nodes;

    public ClickHouseQueryEngine(ClickHouseDatastore datastore) {
        super((Datastore)datastore, (QueryRewriter)new ClickHouseQueryRewriter());
        this.nodes = datastore.servers;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Table retrieveAggregates(DatabaseQuery query, String sql) {
        try (ClickHouseClient client = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});){
            ColumnarTable columnarTable;
            block14: {
                ClickHouseResponse response = (ClickHouseResponse)client.read(this.nodes).format(ClickHouseFormat.RowBinaryWithNamesAndTypes).query(sql).execute().get();
                try {
                    Pair result = ClickHouseQueryEngine.transformToColumnFormat((DatabaseQuery)query, (List)response.getColumns(), (column, name) -> name, (column, name) -> ClickHouseUtil.clickHouseTypeToClass(column.getDataType()), response.records().iterator(), (index, r) -> ClickHouseQueryEngine.getValue(r, index, response.getColumns()), (QueryRewriter)this.queryRewriter);
                    columnarTable = new ColumnarTable((List)result.getOne(), new HashSet(query.measures), (List)result.getTwo());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return columnarTable;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Table executeRawSql(String sql) {
        try (ClickHouseClient client = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});){
            RowTable rowTable;
            block14: {
                ClickHouseResponse response = (ClickHouseResponse)client.read(this.nodes).format(ClickHouseFormat.RowBinaryWithNamesAndTypes).query(sql).execute().get();
                try {
                    Pair result = ClickHouseQueryEngine.transformToRowFormat((List)response.getColumns(), column -> column.getColumnName(), column -> ClickHouseUtil.clickHouseTypeToClass(column.getDataType()), response.records().iterator(), (i, r) -> ClickHouseQueryEngine.getValue(r, i, response.getColumns()));
                    rowTable = new RowTable((List)result.getOne(), (List)result.getTwo());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return rowTable;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(ClickHouseRecord record, int index, List<ClickHouseColumn> columns) {
        ClickHouseValue fieldValue = record.getValue(index);
        ClickHouseColumn column = columns.get(index);
        Object object = fieldValue.asObject();
        if (object == null) {
            return null;
        }
        return switch (column.getDataType()) {
            case ClickHouseDataType.Bool -> fieldValue.asBoolean();
            case ClickHouseDataType.Date -> fieldValue.asDate();
            case ClickHouseDataType.Int8, ClickHouseDataType.UInt32, ClickHouseDataType.Int32, ClickHouseDataType.UInt16, ClickHouseDataType.Int16, ClickHouseDataType.UInt8 -> fieldValue.asInteger();
            case ClickHouseDataType.Int64, ClickHouseDataType.UInt64 -> fieldValue.asLong();
            case ClickHouseDataType.Float32 -> Float.valueOf(fieldValue.asFloat());
            case ClickHouseDataType.Float64 -> fieldValue.asDouble();
            case ClickHouseDataType.String, ClickHouseDataType.FixedString -> fieldValue.asString();
            default -> throw new RuntimeException("Unexpected type " + column.getDataType());
        };
    }

    public List<String> supportedAggregationFunctions() {
        return SUPPORTED_AGGREGATION_FUNCTIONS;
    }

    static class ClickHouseQueryRewriter
    implements QueryRewriter {
        ClickHouseQueryRewriter() {
        }

        public String fieldName(String field) {
            return SqlUtils.backtickEscape((String)field);
        }

        public String measureAlias(String alias) {
            return SqlUtils.backtickEscape((String)alias);
        }

        public boolean usePartialRollupSyntax() {
            return false;
        }
    }
}

