/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import io.squashql.jdbc.JdbcUtil;
import io.squashql.list.Lists;
import java.time.LocalDate;

public final class ClickHouseUtil {
    private ClickHouseUtil() {
    }

    public static String classToClickHouseType(Class<?> clazz) {
        String type;
        if (clazz.equals(String.class)) {
            type = ClickHouseDataType.String.name();
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            type = ClickHouseDataType.Float64.name();
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            type = ClickHouseDataType.Float32.name();
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            type = ClickHouseDataType.Int32.name();
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            type = ClickHouseDataType.Int64.name();
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            type = ClickHouseDataType.Bool.name();
        } else if (clazz.equals(LocalDate.class)) {
            type = ClickHouseDataType.Date.name();
        } else if (clazz.equals(Lists.LongList.class)) {
            type = "Array(Int64)";
        } else if (clazz.equals(Lists.StringList.class)) {
            type = "Array(String)";
        } else if (clazz.equals(Object.class)) {
            type = "json";
        } else {
            throw new IllegalArgumentException("Unsupported field type " + clazz);
        }
        return type;
    }

    public static Class<?> clickHouseTypeToClass(ClickHouseColumn column) {
        ClickHouseDataType dataType = column.getDataType();
        return switch (dataType) {
            case ClickHouseDataType.Array -> JdbcUtil.getListClassFromElementClass(ClickHouseUtil.clickHouseTypeToClass(column.getArrayBaseColumn()));
            default -> dataType.getPrimitiveClass();
        };
    }
}

