/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDataSource;
import com.clickhouse.jdbc.ClickHouseStatement;
import io.squashql.ClickHouseDatastore;
import io.squashql.ClickHouseUtil;
import io.squashql.store.Field;
import io.squashql.transaction.TransactionManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl;

public class ClickHouseTransactionManager
implements TransactionManager {
    protected final ClickHouseDataSource clickHouseDataSource;

    public ClickHouseTransactionManager(ClickHouseDataSource clickHouseDataSource) {
        this.clickHouseDataSource = clickHouseDataSource;
    }

    public void dropAndCreateInMemoryTable(String table, List<Field> fields) {
        ClickHouseTransactionManager.dropAndCreateInMemoryTable(this.clickHouseDataSource, table, fields, true);
    }

    public void dropAndCreateInMemoryTableWithoutScenarioColumn(String table, List<Field> fields) {
        ClickHouseTransactionManager.dropAndCreateInMemoryTable(this.clickHouseDataSource, table, fields, false);
    }

    public static void dropAndCreateInMemoryTable(ClickHouseDataSource clickHouseDataSource, String table, List<Field> fields, boolean cjMode) {
        List list = cjMode ? ImmutableListFactoryImpl.INSTANCE.ofAll(fields).newWith((Object)new Field(table, "scenario", String.class)).castToList() : fields;
        try (ClickHouseConnection conn = clickHouseDataSource.getConnection();
             ClickHouseStatement stmt = conn.createStatement();){
            stmt.execute("drop table if exists " + table);
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Field field = (Field)list.get(i);
                sb.append(field.name()).append(" Nullable(").append(ClickHouseUtil.classToClickHouseType(field.type())).append(')');
                if (i >= size - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            stmt.execute("create table " + table + sb + "engine=Memory");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(String scenario, String store, List<Object[]> tuples) {
        this.ensureScenarioColumnIsPresent(store);
        String join = String.join((CharSequence)",", IntStream.range(0, tuples.get(0).length + 1).mapToObj(i -> "?").toList());
        String pattern = "insert into " + store + " values(" + join + ")";
        try (ClickHouseConnection conn = this.clickHouseDataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(pattern);){
            for (Object[] tuple : tuples) {
                for (int i2 = 0; i2 < tuple.length; ++i2) {
                    stmt.setObject(i2 + 1, tuple[i2]);
                }
                stmt.setObject(tuple.length + 1, scenario);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureScenarioColumnIsPresent(String store) {
        List<Field> fields = ClickHouseDatastore.getFields(this.clickHouseDataSource, store);
        boolean found = fields.stream().anyMatch(f -> f.name().equals("scenario"));
        if (!found) {
            throw new RuntimeException(String.format("%s field not found", "scenario"));
        }
    }

    public void loadCsv(String scenario, String store, String path, String delimiter, boolean header) {
        ClickHouseNode clickHouseNode = ClickHouseNode.of((String)this.clickHouseDataSource.getHost(), (ClickHouseProtocol)ClickHouseProtocol.HTTP, (int)this.clickHouseDataSource.getPort(), null, (String[])new String[0]);
        try {
            CompletableFuture load = ClickHouseClient.load((ClickHouseNode)clickHouseNode, (String)store, (ClickHouseFormat)(header ? ClickHouseFormat.CSVWithNames : ClickHouseFormat.CSV), (ClickHouseCompression)ClickHouseCompression.LZ4, (String)path);
            load.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

