/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseResponse;
import io.squashql.ClickHouseDatastore;
import io.squashql.ClickHouseUtil;
import io.squashql.query.ColumnarTable;
import io.squashql.query.RowTable;
import io.squashql.query.Table;
import io.squashql.query.database.AQueryEngine;
import io.squashql.query.database.DatabaseQuery;
import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SqlUtils;
import io.squashql.store.Datastore;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.tuple.Pair;

public class ClickHouseQueryEngine
extends AQueryEngine<ClickHouseDatastore> {
    public static final List<String> SUPPORTED_AGGREGATION_FUNCTIONS = List.of("count", "min", "max", "sum", "avg", "any", "stddevPop", "stddevSamp", "varPop", "varSamp", "covarPop", "covarSamp");
    protected final ClickHouseNode node;

    public ClickHouseQueryEngine(ClickHouseDatastore datastore) {
        super((Datastore)datastore, (QueryRewriter)new ClickHouseQueryRewriter());
        this.node = ClickHouseNode.builder().host(((ClickHouseDatastore)this.datastore).dataSource.getHost()).port(ClickHouseProtocol.HTTP, Integer.valueOf(((ClickHouseDatastore)this.datastore).dataSource.getPort())).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Table retrieveAggregates(DatabaseQuery query, String sql) {
        try (ClickHouseClient client = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});){
            ColumnarTable columnarTable;
            block14: {
                ClickHouseResponse response = (ClickHouseResponse)client.connect(this.node).format(ClickHouseFormat.RowBinaryWithNamesAndTypes).query(sql).execute().get();
                try {
                    Pair result = ClickHouseQueryEngine.transformToColumnFormat((DatabaseQuery)query, (List)response.getColumns(), (column, name) -> name, (column, name) -> ClickHouseUtil.clickHouseTypeToClass(column.getDataType()), response.records().iterator(), (i, r) -> r.getValue(i.intValue()).asObject(), (QueryRewriter)this.queryRewriter);
                    columnarTable = new ColumnarTable((List)result.getOne(), new HashSet(query.measures), (List)result.getTwo());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return columnarTable;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Table executeRawSql(String sql) {
        try (ClickHouseClient client = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});){
            RowTable rowTable;
            block14: {
                ClickHouseResponse response = (ClickHouseResponse)client.connect(this.node).format(ClickHouseFormat.RowBinaryWithNamesAndTypes).query(sql).execute().get();
                try {
                    Pair result = ClickHouseQueryEngine.transformToRowFormat((List)response.getColumns(), column -> column.getColumnName(), column -> ClickHouseUtil.clickHouseTypeToClass(column.getDataType()), response.records().iterator(), (i, r) -> r.getValue(i.intValue()).asObject());
                    rowTable = new RowTable((List)result.getOne(), (List)result.getTwo());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return rowTable;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> supportedAggregationFunctions() {
        return SUPPORTED_AGGREGATION_FUNCTIONS;
    }

    static class ClickHouseQueryRewriter
    implements QueryRewriter {
        ClickHouseQueryRewriter() {
        }

        public String fieldName(String field) {
            return SqlUtils.backtickEscape((String)field);
        }

        public String measureAlias(String alias) {
            return SqlUtils.backtickEscape((String)alias);
        }

        public boolean usePartialRollupSyntax() {
            return false;
        }

        public boolean useGroupingFunction() {
            return true;
        }
    }
}

