/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDataSource;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.google.common.base.Suppliers;
import io.squashql.ClickHouseUtil;
import io.squashql.store.Datastore;
import io.squashql.store.Field;
import io.squashql.store.Store;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;

public class ClickHouseDatastore
implements Datastore {
    public final Supplier<Map<String, Store>> stores;
    public final ClickHouseDataSource dataSource;

    public ClickHouseDatastore(String jdbc, String databaseName) {
        this.dataSource = ClickHouseDatastore.newDataSource(jdbc, null);
        if (databaseName != null) {
            try (ClickHouseConnection conn = this.dataSource.getConnection();
                 ClickHouseStatement stmt = conn.createStatement();){
                stmt.execute("CREATE DATABASE IF NOT EXISTS " + databaseName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.stores = Suppliers.memoize(() -> ClickHouseDatastore.getTableNames(this.dataSource).stream().collect(() -> new HashMap(), (map, table) -> map.put(table, new Store(table, ClickHouseDatastore.getFields(this.dataSource, table))), (x, y) -> {}));
    }

    public ClickHouseDataSource getDataSource() {
        return this.dataSource;
    }

    public Map<String, Store> storesByName() {
        return this.stores.get();
    }

    private static ClickHouseDataSource newDataSource(String jdbcUrl, Properties properties) {
        try {
            return new ClickHouseDataSource(jdbcUrl, properties);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<String> getTableNames(ClickHouseDataSource dataSource) {
        try {
            DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
            ResultSet tables = metaData.getTables(null, (String)((Object)ClickHouseDefaults.DATABASE.getDefaultValue()), null, null);
            HashSet<String> tableNames = new HashSet<String>();
            while (tables.next()) {
                tableNames.add((String)tables.getObject("TABLE_NAME"));
            }
            return tableNames;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getFields(ClickHouseDataSource dataSource, String table) {
        try {
            DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
            ResultSet columns = metaData.getColumns(null, (String)((Object)ClickHouseDefaults.DATABASE.getDefaultValue()), table, null);
            ArrayList<Field> fields = new ArrayList<Field>();
            while (columns.next()) {
                String columnName = (String)columns.getObject("COLUMN_NAME");
                String typeName = (String)columns.getObject("TYPE_NAME");
                ClickHouseColumn column = ClickHouseColumn.of((String)"", (String)typeName);
                fields.add(new Field(table, columnName, ClickHouseUtil.clickHouseTypeToClass(column.getDataType())));
            }
            return fields;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

