/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SqlUtils;
import io.squashql.query.date.DateFunctions;
import io.squashql.type.FunctionTypedField;

public class BigQueryQueryRewriter
implements QueryRewriter {
    private final String projectId;
    private final String datasetName;

    BigQueryQueryRewriter(String projectId, String datasetName) {
        this.projectId = projectId;
        this.datasetName = datasetName;
    }

    public String functionExpression(FunctionTypedField ftf) {
        if (DateFunctions.SUPPORTED_DATE_FUNCTIONS.contains(ftf.function())) {
            return String.format("EXTRACT(%s FROM %s)", ftf.function(), this.getFieldFullName(ftf.field()));
        }
        throw new IllegalArgumentException("Unsupported function " + ftf);
    }

    public String fieldName(String field) {
        return SqlUtils.backtickEscape((String)field);
    }

    public String tableName(String table) {
        return SqlUtils.backtickEscape((String)(this.projectId + "." + this.datasetName + "." + table));
    }

    public String measureAlias(String alias) {
        return SqlUtils.backtickEscape((String)alias).replace("(", "_").replace(")", "_").replace(" ", "_");
    }

    public boolean usePartialRollupSyntax() {
        return false;
    }

    public String escapeSingleQuote(String s) {
        return SqlUtils.escapeSingleQuote((String)s, (String)"\\'");
    }
}

